"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LeftPanelVisualizeTab = exports.LeftPanelResponseTab = exports.LeftPanelInvestigationTab = exports.LeftPanelInsightsTab = exports.LeftPanel = exports.DocumentDetailsLeftPanelKey = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _header = require("./header");
var _content = require("./content");
var _tabs = require("./tabs");
var _context = require("./context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentDetailsLeftPanelKey = 'document-details-left';
exports.DocumentDetailsLeftPanelKey = DocumentDetailsLeftPanelKey;
const LeftPanelVisualizeTab = 'visualize';
exports.LeftPanelVisualizeTab = LeftPanelVisualizeTab;
const LeftPanelInsightsTab = 'insights';
exports.LeftPanelInsightsTab = LeftPanelInsightsTab;
const LeftPanelInvestigationTab = 'investigation';
exports.LeftPanelInvestigationTab = LeftPanelInvestigationTab;
const LeftPanelResponseTab = 'response';
exports.LeftPanelResponseTab = LeftPanelResponseTab;
const LeftPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const {
    eventId,
    indexName,
    scopeId
  } = (0, _context.useLeftPanelContext)();
  const selectedTabId = (0, _react.useMemo)(() => {
    var _visibleTabs$map$find;
    const visibleTabs = _tabs.tabs.filter(tab => tab.visible);
    const defaultTab = visibleTabs[0].id;
    if (!path) return defaultTab;
    return (_visibleTabs$map$find = visibleTabs.map(tab => tab.id).find(tabId => tabId === path.tab)) !== null && _visibleTabs$map$find !== void 0 ? _visibleTabs$map$find : defaultTab;
  }, [path]);
  const setSelectedTabId = tabId => {
    openLeftPanel({
      id: DocumentDetailsLeftPanelKey,
      path: {
        tab: tabId
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.PanelHeader, {
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId
  }), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    selectedTabId: selectedTabId
  }));
});
exports.LeftPanel = LeftPanel;
LeftPanel.displayName = 'LeftPanel';