"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNotNull = exports.createUserAssetTableLocalStorageEpic = void 0;
var _operators = require("rxjs/operators");
var _fp = require("lodash/fp");
var _ = require(".");
var _selectors = require("./selectors");
var _storage = require("./storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isNotNull = value => value !== null;
exports.isNotNull = isNotNull;
const {
  removeUserAssetTableField,
  addUserAssetTableField
} = _.usersActions;
const tableActionTypes = new Set([removeUserAssetTableField.type, addUserAssetTableField.type]);
const createUserAssetTableLocalStorageEpic = () => (action$, state$, {
  storage
}) => {
  const table$ = state$.pipe((0, _operators.map)(_selectors.selectUserAssetTables), (0, _operators.filter)(isNotNull));
  return action$.pipe((0, _operators.delay)(500), (0, _operators.withLatestFrom)(table$), (0, _operators.tap)(([action, tableById]) => {
    if (tableActionTypes.has(action.type)) {
      const tableId = (0, _fp.get)('payload.tableId', action);
      (0, _storage.persistUserAssetTableInStorage)(storage, tableId, tableById[tableId]);
    }
  }), (0, _operators.ignoreElements)());
};
exports.createUserAssetTableLocalStorageEpic = createUserAssetTableLocalStorageEpic;