"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostsColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _cell_actions = require("../../../../common/components/cell_actions");
var _empty_value = require("../../../../common/components/empty_value");
var _links = require("../../../../common/components/links");
var _formatted_date = require("../../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
var _search_strategy = require("../../../../../common/search_strategy");
var _translations2 = require("../host_risk_score_table/translations");
var _common = require("../../../components/risk_score/severity/common");
var _translations3 = require("../../../components/risk_score/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHostsColumns = (showRiskColumn, dispatchSeverityUpdate) => {
  const columns = [{
    field: 'node.host.name',
    name: i18n.NAME,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    render: hostName => {
      if (hostName != null && hostName.length > 0) {
        return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
          mode: _cell_actions.CellActionsMode.HOVER_DOWN,
          visibleCellActions: 5,
          showActionTooltips: true,
          triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
          data: {
            value: hostName[0],
            field: 'host.name'
          }
        }, /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
          hostName: hostName[0]
        }));
      }
      return (0, _empty_value.getEmptyTagValue)();
    },
    width: '35%'
  }, {
    field: 'node.lastSeen',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.FIRST_LAST_SEEN_TOOLTIP
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.LAST_SEEN, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "subdued",
      type: "iInCircle",
      className: "eui-alignTop"
    }))),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    render: lastSeen => {
      if (lastSeen != null && lastSeen.length > 0) {
        return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
          value: Array.isArray(lastSeen) ? lastSeen[0] : lastSeen
        });
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: 'node.host.os.name',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.OS_LAST_SEEN_TOOLTIP
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.OS, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "subdued",
      type: "iInCircle",
      className: "eui-alignTop"
    }))),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: false,
    render: hostOsName => {
      if (hostOsName != null) {
        return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
          mode: _cell_actions.CellActionsMode.HOVER_DOWN,
          visibleCellActions: 5,
          showActionTooltips: true,
          triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
          data: {
            value: hostOsName[0],
            field: 'host.os.name'
          }
        }, hostOsName);
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: 'node.host.os.version',
    name: i18n.VERSION,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: false,
    render: hostOsVersion => {
      if (hostOsVersion != null) {
        return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
          mode: _cell_actions.CellActionsMode.HOVER_DOWN,
          visibleCellActions: 5,
          showActionTooltips: true,
          triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
          data: {
            value: hostOsVersion[0],
            field: 'host.os.version'
          }
        }, hostOsVersion);
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }];
  if (showRiskColumn) {
    columns.push({
      field: 'node.risk',
      name: (0, _translations3.ENTITY_RISK_LEVEL)(_search_strategy.RiskScoreEntity.host),
      truncateText: false,
      mobileOptions: {
        show: true
      },
      sortable: false,
      render: riskScore => {
        if (riskScore != null) {
          return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
            toolTipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              onClick: () => dispatchSeverityUpdate(riskScore)
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
              size: "xs"
            }, (0, _translations2.VIEW_HOSTS_BY_SEVERITY)(riskScore.toLowerCase()))),
            severity: riskScore
          });
        }
        return (0, _empty_value.getEmptyTagValue)();
      }
    });
  }
  return columns;
};
exports.getHostsColumns = getHostsColumns;