"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_DASHBOARD_BUTTON = exports.RISK_SCORE_OVER_TIME = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RISK_SCORE_OVER_TIME = riskEntity => _i18n.i18n.translate('xpack.securitySolution.riskTabBody.scoreOverTimeTitle', {
  defaultMessage: '{riskEntity} risk score over time',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity)
  }
});
exports.RISK_SCORE_OVER_TIME = RISK_SCORE_OVER_TIME;
const VIEW_DASHBOARD_BUTTON = _i18n.i18n.translate('xpack.securitySolution.riskTabBody.viewDashboardButtonLabel', {
  defaultMessage: 'View source dashboard'
});
exports.VIEW_DASHBOARD_BUTTON = VIEW_DASHBOARD_BUTTON;