"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsManagementPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _risk_score_preview_section = require("../components/risk_score_preview_section");
var _risk_score_enable_section = require("../components/risk_score_enable_section");
var _translations = require("../../app/translations");
var _translations2 = require("../../common/translations");
var _risk_engine_privileges_callout = require("../components/risk_engine_privileges_callout");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityAnalyticsManagementPage = () => {
  const privilegesCalloutEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('riskEnginePrivilegesRouteEnabled');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, privilegesCalloutEnabled && /*#__PURE__*/_react.default.createElement(_risk_engine_privileges_callout.RiskEnginePrivilegesCallOut, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "entityAnalyticsManagementPageTitle",
    pageTitle: _translations.ENTITY_ANALYTICS_RISK_SCORE
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _translations2.BETA,
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_risk_score_enable_section.RiskScoreEnableSection, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_risk_score_preview_section.RiskScorePreviewSection, null))));
};
exports.EntityAnalyticsManagementPage = EntityAnalyticsManagementPage;
EntityAnalyticsManagementPage.displayName = 'EntityAnalyticsManagementPage';