"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreEnableSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _links = require("@kbn/security-solution-navigation/links");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_risk_engine_status = require("../api/hooks/use_risk_engine_status");
var _use_init_risk_engine_mutation = require("../api/hooks/use_init_risk_engine_mutation");
var _use_enable_risk_engine_mutation = require("../api/hooks/use_enable_risk_engine_mutation");
var _use_disable_risk_engine_mutation = require("../api/hooks/use_disable_risk_engine_mutation");
var _risk_engine = require("../../../common/risk_engine");
var _risk_information = require("../../explore/components/risk_score/risk_information");
var _helper_hooks = require("../../helper_hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_WIDTH_TO_PREVENT_LABEL_FROM_MOVING = '50px';
const RiskScoreErrorPanel = ({
  errors
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: i18n.ERROR_PANEL_TITLE,
  color: "danger",
  iconType: "error",
  "data-test-subj": "risk-score-error-panel"
}, /*#__PURE__*/_react.default.createElement("p", null, i18n.ERROR_PANEL_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
  id: "risk-engine-erros",
  buttonContent: i18n.ERROR_PANEL_ERRORS
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errors.map(error => /*#__PURE__*/_react.default.createElement("div", {
  key: error
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, error), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}))))), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
  id: "risk-engine-privileges",
  buttonContent: i18n.CHECK_PRIVILEGES
}, /*#__PURE__*/_react.default.createElement("p", null, i18n.NEED_TO_HAVE, /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.riskScore.errors.privileges.requiredPrivilege",
  defaultMessage: "{required_privilege} privileges for {index} index",
  values: {
    required_privilege: /*#__PURE__*/_react.default.createElement("b", null, 'all'),
    index: /*#__PURE__*/_react.default.createElement("b", null, 'risk-score.risk-score-*')
  }
})), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.riskScore.errors.privileges.securityPrivilege",
  defaultMessage: "{security_privileges} security privileges",
  values: {
    security_privileges: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("b", null, 'manage_index_templates'), ',', " ", /*#__PURE__*/_react.default.createElement("b", null, 'manage_transform'))
  }
})), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.riskScore.errors.privileges.kibanaPrivilege",
  defaultMessage: "{kibana_privilege} Kibana privilege",
  values: {
    kibana_privilege: /*#__PURE__*/_react.default.createElement("b", null, 'Saved Objects Management')
  }
})))))));
const RiskScoreUpdateModal = ({
  closeModal,
  isLoading,
  onConfirm,
  isVisible
}) => {
  if (!isVisible) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, i18n.UPDATING_RISK_ENGINE))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, i18n.UPDATE_RISK_ENGINE_MODAL_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("b", null, i18n.UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_1), i18n.UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_2), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("b", null, i18n.UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_1), i18n.UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_2)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    "data-test-subj": "risk-score-update-cancel",
    onClick: closeModal
  }, i18n.UPDATE_RISK_ENGINE_MODAL_BUTTON_NO), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "risk-score-update-confirm",
    onClick: onConfirm,
    fill: true
  }, i18n.UPDATE_RISK_ENGINE_MODAL_BUTTON_YES))));
};
const RiskScoreEnableSection = () => {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    data: riskEngineStatus,
    isFetching: isStatusLoading
  } = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const initRiskEngineMutation = (0, _use_init_risk_engine_mutation.useInitRiskEngineMutation)({
    onSettled: () => {
      setIsModalVisible(false);
    }
  });
  const enableRiskEngineMutation = (0, _use_enable_risk_engine_mutation.useEnableRiskEngineMutation)();
  const disableRiskEngineMutation = (0, _use_disable_risk_engine_mutation.useDisableRiskEngineMutation)();
  const currentRiskEngineStatus = riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_status;
  const closeModal = () => setIsModalVisible(false);
  const showModal = () => setIsModalVisible(true);
  const [isFlyoutVisible, handleOnOpen, handleOnClose] = (0, _helper_hooks.useOnOpenCloseHandler)();
  const isLoading = initRiskEngineMutation.isLoading || enableRiskEngineMutation.isLoading || disableRiskEngineMutation.isLoading || isStatusLoading;
  const isUpdateAvailable = riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.isUpdateAvailable;
  const btnIsDisabled = !currentRiskEngineStatus || isLoading;
  const onSwitchClick = () => {
    if (btnIsDisabled) {
      return;
    }
    if (currentRiskEngineStatus === _risk_engine.RiskEngineStatus.NOT_INSTALLED) {
      initRiskEngineMutation.mutate();
    } else if (currentRiskEngineStatus === _risk_engine.RiskEngineStatus.ENABLED) {
      disableRiskEngineMutation.mutate();
    } else if (currentRiskEngineStatus === _risk_engine.RiskEngineStatus.DISABLED) {
      enableRiskEngineMutation.mutate();
    }
  };
  let initRiskEngineErrors = [];
  if (initRiskEngineMutation.isError) {
    var _errorBody$full_error;
    const errorBody = initRiskEngineMutation.error.body;
    if (errorBody !== null && errorBody !== void 0 && (_errorBody$full_error = errorBody.full_error) !== null && _errorBody$full_error !== void 0 && _errorBody$full_error.errors) {
      var _errorBody$full_error2;
      initRiskEngineErrors = (_errorBody$full_error2 = errorBody.full_error) === null || _errorBody$full_error2 === void 0 ? void 0 : _errorBody$full_error2.errors;
    } else {
      initRiskEngineErrors = [errorBody.message];
    }
  }
  if (currentRiskEngineStatus !== _risk_engine.RiskEngineStatus.ENABLED && riskEngineStatus !== null && riskEngineStatus !== void 0 && riskEngineStatus.is_max_amount_of_risk_engines_reached) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18n.getMaxSpaceTitle(_risk_engine.MAX_SPACES_COUNT),
      color: "warning",
      iconType: "error",
      "data-test-subj": "risk-score-warning-panel"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18n.MAX_SPACE_PANEL_MESSAGE));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, i18n.RISK_SCORE_MODULE_STATUS)), initRiskEngineMutation.isError && /*#__PURE__*/_react.default.createElement(RiskScoreErrorPanel, {
    errors: initRiskEngineErrors
  }), disableRiskEngineMutation.isError && /*#__PURE__*/_react.default.createElement(RiskScoreErrorPanel, {
    errors: [disableRiskEngineMutation.error.body.message]
  }), enableRiskEngineMutation.isError && /*#__PURE__*/_react.default.createElement(RiskScoreErrorPanel, {
    errors: [enableRiskEngineMutation.error.body.message]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(RiskScoreUpdateModal, {
    isVisible: isModalVisible,
    onConfirm: () => initRiskEngineMutation.mutate(),
    isLoading: initRiskEngineMutation.isLoading,
    closeModal: closeModal
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: 'baseline'
  }, i18n.ENTITY_RISK_SCORING, isUpdateAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success"
  }, i18n.UPDATE_AVAILABLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isUpdateAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, initRiskEngineMutation.isLoading && !isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: initRiskEngineMutation.isLoading,
    color: 'primary',
    onClick: showModal,
    "data-test-subj": "risk-score-update-button"
  }, i18n.START_UPDATE)), !isUpdateAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "risk-score-status-loading",
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: MIN_WIDTH_TO_PREVENT_LABEL_FROM_MOVING
    },
    "data-test-subj": "risk-score-status"
  }, currentRiskEngineStatus === _risk_engine.RiskEngineStatus.ENABLED ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "success"
  }, i18n.RISK_SCORE_MODULE_STATUS_ON) : /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued"
  }, i18n.RISK_SCORE_MODULE_STATUS_OFF)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: '',
    "data-test-subj": "risk-score-switch",
    checked: currentRiskEngineStatus === _risk_engine.RiskEngineStatus.ENABLED,
    onChange: onSwitchClick,
    compressed: true,
    disabled: btnIsDisabled,
    "aria-describedby": 'switchRiskModule'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, i18n.USEFUL_LINKS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    id: _securitySolutionNavigation.SecurityPageName.entityAnalytics
  }, i18n.EA_DASHBOARD_LINK), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: handleOnOpen,
    "data-test-subj": "open-risk-information-flyout-trigger"
  }, i18n.EA_DOCS_ENTITY_RISK_SCORE), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_risk_information.RiskInformationFlyout, {
    handleOnClose: handleOnClose
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))));
};
exports.RiskScoreEnableSection = RiskScoreEnableSection;