"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnableRiskEngineMutation = exports.ENABLE_RISK_ENGINE_MUTATION_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _api = require("../api");
var _use_risk_engine_status = require("./use_risk_engine_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENABLE_RISK_ENGINE_MUTATION_KEY = ['POST', 'ENABLE_RISK_ENGINE'];
exports.ENABLE_RISK_ENGINE_MUTATION_KEY = ENABLE_RISK_ENGINE_MUTATION_KEY;
const useEnableRiskEngineMutation = options => {
  const invalidateRiskEngineStatusQuery = (0, _use_risk_engine_status.useInvalidateRiskEngineStatusQuery)();
  return (0, _reactQuery.useMutation)(() => (0, _api.enableRiskEngine)(), {
    ...options,
    mutationKey: ENABLE_RISK_ENGINE_MUTATION_KEY,
    onSettled: (...args) => {
      invalidateRiskEngineStatusQuery();
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    }
  });
};
exports.useEnableRiskEngineMutation = useEnableRiskEngineMutation;