"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _formatted_date = require("../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
var _form = require("./form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlignedSpinner = (0, _styledComponents.default)(_eui.EuiLoadingSpinner)`
  margin: ${({
  theme
}) => theme.eui.euiSizeXS};
  vertical-align: middle;
`;
const buildColumns = (onExport, onDelete) => [{
  field: 'name',
  name: i18n.COLUMN_FILE_NAME,
  truncateText: false
}, {
  field: 'type',
  name: i18n.COLUMN_TYPE,
  width: '15%',
  truncateText: true,
  render: type => {
    const option = _form.listFormOptions.find(({
      value
    }) => value === type);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, option ? option.text : type);
  }
}, {
  field: 'created_at',
  name: i18n.COLUMN_UPLOAD_DATE,
  render: value => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
    value: value,
    fieldName: "created_at"
  }),
  width: '30%'
}, {
  field: 'created_by',
  name: i18n.COLUMN_CREATED_BY,
  truncateText: true,
  width: '20%'
}, {
  name: i18n.COLUMN_ACTIONS,
  actions: [{
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.ACTION_EXPORT_DESCRIPTION
    }, item.isExporting ? /*#__PURE__*/_react.default.createElement(AlignedSpinner, {
      size: "m"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": i18n.ACTION_EXPORT_DESCRIPTION,
      "data-test-subj": "action-export-value-list",
      iconType: "exportAction",
      onClick: () => onExport(item)
    }))
  }, {
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.ACTION_DELETE_DESCRIPTION
    }, item.isDeleting ? /*#__PURE__*/_react.default.createElement(AlignedSpinner, {
      size: "m"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": i18n.ACTION_DELETE_DESCRIPTION,
      "data-test-subj": `action-delete-value-list-${item.name}`,
      iconType: "trash",
      onClick: () => onDelete(item)
    }))
  }],
  width: '15%'
}];
exports.buildColumns = buildColumns;