"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _fp = require("lodash/fp");
var _uiTheme = require("@kbn/ui-theme");
var _health_truncate_text = require("../../../../common/components/health_truncate_text");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  euiColorVis0,
  euiColorVis5,
  euiColorVis7,
  euiColorVis9
} = _uiTheme.euiLightVars;
const severityToColorMap = {
  low: euiColorVis0,
  medium: euiColorVis5,
  high: euiColorVis7,
  critical: euiColorVis9
};
const SeverityBadgeComponent = ({
  value,
  'data-test-subj': dataTestSubj = 'severity'
}) => {
  var _severityToColorMap$v;
  const displayValue = (0, _fp.upperFirst)(value);
  const color = (_severityToColorMap$v = severityToColorMap[value]) !== null && _severityToColorMap$v !== void 0 ? _severityToColorMap$v : 'subdued';
  return /*#__PURE__*/_react.default.createElement(_health_truncate_text.HealthTruncateText, {
    healthColor: color,
    tooltipContent: displayValue,
    dataTestSubj: dataTestSubj
  }, displayValue);
};
const SeverityBadge = /*#__PURE__*/_react.default.memo(SeverityBadgeComponent);
exports.SeverityBadge = SeverityBadge;