"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PICK_INDEX_PATTERNS = exports.DDATA_VIEW_ALERTS_ON_ALERTS_WARNING_LABEL = exports.DATA_VIEW_NOT_FOUND_WARNING_LABEL = exports.DATA_VIEW_NOT_FOUND_WARNING_DESCRIPTION = exports.DATA_VIEW_ALERTS_ON_ALERTS_WARNING_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PICK_INDEX_PATTERNS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.stepDefineRule.pickDataView', {
  defaultMessage: 'Select a Data View'
});
exports.PICK_INDEX_PATTERNS = PICK_INDEX_PATTERNS;
const DATA_VIEW_NOT_FOUND_WARNING_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.stepDefineRule.dataViewNotFoundLabel', {
  defaultMessage: 'Selected data view not found'
});
exports.DATA_VIEW_NOT_FOUND_WARNING_LABEL = DATA_VIEW_NOT_FOUND_WARNING_LABEL;
const DATA_VIEW_NOT_FOUND_WARNING_DESCRIPTION = dataView => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.stepDefineRule.dataViewNotFoundDescription', {
  values: {
    dataView
  },
  defaultMessage: 'Your data view of "id": "{dataView}" was not found. It could be that it has since been deleted.'
});
exports.DATA_VIEW_NOT_FOUND_WARNING_DESCRIPTION = DATA_VIEW_NOT_FOUND_WARNING_DESCRIPTION;
const DDATA_VIEW_ALERTS_ON_ALERTS_WARNING_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.stepDefineRule.dataViewIncludesAlertsIndexLabel', {
  defaultMessage: 'Default Security data view'
});
exports.DDATA_VIEW_ALERTS_ON_ALERTS_WARNING_LABEL = DDATA_VIEW_ALERTS_ON_ALERTS_WARNING_LABEL;
const DATA_VIEW_ALERTS_ON_ALERTS_WARNING_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.stepDefineRule.dataViewIncludesAlertsIndexDescription', {
  defaultMessage: 'The default Security data view includes the alerts index. This could result in redundant alerts being generated from existing alerts.'
});
exports.DATA_VIEW_ALERTS_ON_ALERTS_WARNING_DESCRIPTION = DATA_VIEW_ALERTS_ON_ALERTS_WARNING_DESCRIPTION;