"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../../common/lib/kibana");
var _osquery_flyout_footer = require("./osquery_flyout_footer");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OsqueryActionWrapper = _styledComponents.default.div`
  padding: 8px;
`;
// Make sure we keep this and ACTIONS_QUERY_KEY in use_all_live_queries.ts in sync.
const ACTIONS_QUERY_KEY = 'actions';
const OsqueryFlyoutComponent = ({
  agentId,
  defaultValues,
  onClose,
  ecsData
}) => {
  const {
    services: {
      osquery
    }
  } = (0, _kibana.useKibana)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const invalidateQueries = (0, _react.useCallback)(() => {
    var _defaultValues$alertI;
    queryClient.invalidateQueries({
      queryKey: [ACTIONS_QUERY_KEY, {
        alertId: defaultValues === null || defaultValues === void 0 ? void 0 : (_defaultValues$alertI = defaultValues.alertIds) === null || _defaultValues$alertI === void 0 ? void 0 : _defaultValues$alertI[0]
      }]
    });
  }, [defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues.alertIds, queryClient]);
  if (osquery !== null && osquery !== void 0 && osquery.OsqueryAction) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      size: "m",
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      "data-test-subj": "flyout-header-osquery"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _translations.ACTION_OSQUERY))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(OsqueryActionWrapper, {
      "data-test-subj": "flyout-body-osquery"
    }, /*#__PURE__*/_react.default.createElement(osquery.OsqueryAction, {
      agentId: agentId,
      formType: "steps",
      defaultValues: defaultValues,
      ecsData: ecsData,
      onSuccess: invalidateQueries
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_osquery_flyout_footer.OsqueryEventDetailsFooter, {
      handleClick: onClose,
      "data-test-subj": "flyout-footer-osquery"
    })));
  }
  return null;
};
const OsqueryFlyout = /*#__PURE__*/_react.default.memo(OsqueryFlyoutComponent);
exports.OsqueryFlyout = OsqueryFlyout;