"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobUpgradeModalBody = exports.ML_JOB_UPGRADE_MODAL_TITLE = exports.ML_JOB_UPGRADE_MODAL_CONFIRM = exports.ML_JOB_UPGRADE_MODAL_CANCEL = exports.ML_JOB_UPGRADE_MODAL_AFFECTED_JOBS = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _links_to_docs = require("../../../../common/components/links_to_docs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ML_JOB_UPGRADE_MODAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlJobUpgradeModal.messageTitle', {
  defaultMessage: 'ML rule updates may override your existing rules'
});
exports.ML_JOB_UPGRADE_MODAL_TITLE = ML_JOB_UPGRADE_MODAL_TITLE;
const ML_JOB_UPGRADE_MODAL_CANCEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlJobUpgradeModal.cancelTitle', {
  defaultMessage: 'Cancel'
});
exports.ML_JOB_UPGRADE_MODAL_CANCEL = ML_JOB_UPGRADE_MODAL_CANCEL;
const ML_JOB_UPGRADE_MODAL_CONFIRM = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlJobUpgradeModal.confirmTitle', {
  defaultMessage: 'Load rules'
});
exports.ML_JOB_UPGRADE_MODAL_CONFIRM = ML_JOB_UPGRADE_MODAL_CONFIRM;
const ML_JOB_UPGRADE_MODAL_AFFECTED_JOBS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlJobUpgradeModal.affectedJobsTitle', {
  defaultMessage: 'Affected jobs:'
});
exports.ML_JOB_UPGRADE_MODAL_AFFECTED_JOBS = ML_JOB_UPGRADE_MODAL_AFFECTED_JOBS;
const MlJobUpgradeModalBody = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.mlJobUpgradeModal.messageBody",
  defaultMessage: "{summary} Documentation: {docs}",
  values: {
    summary: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.mlJobUpgradeModal.messageBody.summary",
      defaultMessage: "New V3 machine learning jobs have been released, and the latest corresponding prebuilt detection rules now use these new ML jobs. You're currently running one or more V1/V2 jobs, which only work with legacy prebuilt rules. To ensure continued coverage using V1/V2 jobs, you may need to duplicate or create new rules before updating your Elastic prebuilt detection rules. Check the documentation below for instructions on how to keep using the V1/V2 jobs, and how to start using the new V3 jobs."
    })),
    docs: /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_links_to_docs.MlJobCompatibilityLink, null)))
  }
});
exports.MlJobUpgradeModalBody = MlJobUpgradeModalBody;