"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostIsolationPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sentinelone_alert_check = require("../../../common/utils/sentinelone_alert_check");
var _use_cases_from_alerts = require("../../containers/detection_engine/alerts/use_cases_from_alerts");
var _isolate_sentinelone = require("./isolate_sentinelone");
var _unisolate_sentinelone = require("./unisolate_sentinelone");
var _helpers = require("./helpers");
var _isolate = require("./isolate");
var _unisolate = require("./unisolate");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostIsolationPanel = /*#__PURE__*/_react.default.memo(({
  details,
  cancelCallback,
  successCallback,
  isolateAction
}) => {
  const endpointId = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'agent',
    field: 'agent.id'
  }, details), [details]);
  const sentinelOneAgentId = (0, _react.useMemo)(() => (0, _sentinelone_alert_check.getSentinelOneAgentId)(details), [details]);
  const hostName = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'host',
    field: 'host.name'
  }, details), [details]);
  const alertId = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: '_id',
    field: '_id'
  }, details), [details]);
  const {
    casesInfo
  } = (0, _use_cases_from_alerts.useCasesFromAlerts)({
    alertId
  });
  if (sentinelOneAgentId) {
    return isolateAction === 'isolateHost' ? /*#__PURE__*/_react.default.createElement(_isolate_sentinelone.IsolateSentinelOneHost, {
      sentinelOneAgentId: sentinelOneAgentId,
      hostName: hostName,
      cancelCallback: cancelCallback,
      successCallback: successCallback
    }) : /*#__PURE__*/_react.default.createElement(_unisolate_sentinelone.UnisolateSentinelOneHost, {
      sentinelOneAgentId: sentinelOneAgentId,
      hostName: hostName,
      cancelCallback: cancelCallback,
      successCallback: successCallback
    });
  }
  return isolateAction === 'isolateHost' ? /*#__PURE__*/_react.default.createElement(_isolate.IsolateHost, {
    endpointId: endpointId,
    hostName: hostName,
    casesInfo: casesInfo,
    cancelCallback: cancelCallback,
    successCallback: successCallback
  }) : /*#__PURE__*/_react.default.createElement(_unisolate.UnisolateHost, {
    endpointId: endpointId,
    hostName: hostName,
    casesInfo: casesInfo,
    cancelCallback: cancelCallback,
    successCallback: successCallback
  });
});
exports.HostIsolationPanel = HostIsolationPanel;
HostIsolationPanel.displayName = 'HostIsolationContent';