"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalFiltersAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _utility_bar = require("../../../../common/components/utility_bar");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UtilityBarFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  min-width: 175px;
`;
const AdditionalFiltersItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const BuildingBlockContainer = (0, _styledComponents.default)(AdditionalFiltersItem)`
  background: ${({
  theme
}) => theme.eui.euiColorHighlight};
`;
const AdditionalFiltersAction = ({
  areEventsLoading,
  onShowBuildingBlockAlertsChanged,
  showBuildingBlockAlerts,
  onShowOnlyThreatIndicatorAlertsChanged,
  showOnlyThreatIndicatorAlerts
}) => {
  const UtilityBarAdditionalFiltersContent = (0, _react.useCallback)(closePopover => /*#__PURE__*/_react.default.createElement(UtilityBarFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(BuildingBlockContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "showBuildingBlockAlertsCheckbox",
    "aria-label": "showBuildingBlockAlerts",
    onChange: e => {
      closePopover();
      onShowBuildingBlockAlertsChanged(e.target.checked);
    },
    checked: showBuildingBlockAlerts,
    color: "text",
    "data-test-subj": "showBuildingBlockAlertsCheckbox",
    label: i18n.ADDITIONAL_FILTERS_ACTIONS_SHOW_BUILDING_BLOCK
  })), /*#__PURE__*/_react.default.createElement(AdditionalFiltersItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "showOnlyThreatIndicatorAlertsCheckbox",
    "aria-label": "showOnlyThreatIndicatorAlerts",
    onChange: e => {
      closePopover();
      onShowOnlyThreatIndicatorAlertsChanged(e.target.checked);
    },
    checked: showOnlyThreatIndicatorAlerts,
    color: "text",
    "data-test-subj": "showOnlyThreatIndicatorAlertsCheckbox",
    label: i18n.ADDITIONAL_FILTERS_ACTIONS_SHOW_ONLY_THREAT_INDICATOR_ALERTS
  }))), [onShowBuildingBlockAlertsChanged, onShowOnlyThreatIndicatorAlertsChanged, showBuildingBlockAlerts, showOnlyThreatIndicatorAlerts]);
  return /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "additionalFilters",
    disabled: areEventsLoading,
    iconType: "arrowDown",
    iconSide: "right",
    ownFocus: true,
    popoverContent: UtilityBarAdditionalFiltersContent
  }, i18n.ADDITIONAL_FILTERS_ACTIONS);
};
exports.AdditionalFiltersAction = AdditionalFiltersAction;