"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggregatableFields = getAggregatableFields;
exports.isDataViewFieldSubtypeNested = isDataViewFieldSubtypeNested;
exports.useStackByFields = exports.useInspectButton = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _source = require("../../../../common/containers/source");
var _lens = require("../../../../common/utils/lens");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * * Add query to inspect button utility.
 * * Delete query from inspect button utility when component unmounts
 */
const useInspectButton = ({
  setQuery,
  response,
  request,
  refetch,
  uniqueQueryId,
  deleteQuery,
  loading,
  searchSessionId
}) => {
  (0, _react.useEffect)(() => {
    if (refetch != null && setQuery != null) {
      setQuery({
        id: uniqueQueryId,
        inspect: {
          dsl: [request],
          response: [response]
        },
        loading,
        refetch,
        searchSessionId
      });
    }
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: uniqueQueryId
        });
      }
    };
  }, [setQuery, loading, response, request, refetch, uniqueQueryId, deleteQuery, searchSessionId]);
};
exports.useInspectButton = useInspectButton;
function isDataViewFieldSubtypeNested(field) {
  var _subTypeNested$nested;
  const subTypeNested = field === null || field === void 0 ? void 0 : field.subType;
  return !!(subTypeNested !== null && subTypeNested !== void 0 && (_subTypeNested$nested = subTypeNested.nested) !== null && _subTypeNested$nested !== void 0 && _subTypeNested$nested.path);
}
function getAggregatableFields(fields, useLensCompatibleFields) {
  const result = [];
  for (const [key, field] of Object.entries(fields)) {
    if (useLensCompatibleFields) {
      if (!!field.aggregatable && (0, _lens.isLensSupportedType)(field.type) && !isDataViewFieldSubtypeNested(field)) {
        result.push({
          label: key,
          value: key
        });
      }
    } else {
      if (field.aggregatable === true) {
        result.push({
          label: key,
          value: key
        });
      }
    }
  }
  return result;
}
const useStackByFields = useLensCompatibleFields => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    browserFields
  } = (0, _sourcerer.useSourcererDataView)((0, _sourcerer.getScopeFromPath)(pathname));
  return (0, _react.useCallback)(() => {
    try {
      return getAggregatableFields((0, _source.getAllFieldsByName)(browserFields), useLensCompatibleFields);
    } catch (err) {
      addError(err, {
        title: _i18n.i18n.translate('xpack.securitySolution.useStackByFields.error.title', {
          defaultMessage: 'Error fetching fields'
        }),
        toastMessage: _i18n.i18n.translate('xpack.securitySolution.useStackByFields.error.toastMessage', {
          defaultMessage: 'This error indicates an exceedingly large number of fields in an index'
        })
      });
      return [];
    }
  }, [addError, browserFields, useLensCompatibleFields]);
};
exports.useStackByFields = useStackByFields;