"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSupportedResponseActionTypes = void 0;
var _react = require("react");
var _user_privileges = require("../../common/components/user_privileges");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _get_supported_response_actions = require("./get_supported_response_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSupportedResponseActionTypes = () => {
  const [supportedResponseActionTypes, setSupportedResponseActionTypes] = (0, _react.useState)();
  const isEndpointEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointResponseActionsEnabled');
  const {
    canIsolateHost
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const enabledFeatures = (0, _react.useMemo)(() => ({
    endpoint: isEndpointEnabled
  }), [isEndpointEnabled]);
  const userHasPermissionsToExecute = (0, _react.useMemo)(() => ({
    endpoint: canIsolateHost
  }), [canIsolateHost]);
  (0, _react.useEffect)(() => {
    const supportedTypes = (0, _get_supported_response_actions.getSupportedResponseActions)(_get_supported_response_actions.responseActionTypes, enabledFeatures, userHasPermissionsToExecute);
    setSupportedResponseActionTypes(supportedTypes);
  }, [isEndpointEnabled, enabledFeatures, userHasPermissionsToExecute]);
  return supportedResponseActionTypes;
};
exports.useSupportedResponseActionTypes = useSupportedResponseActionTypes;