"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewLegend = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LegendLabel = ({
  label,
  color
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFacetButton, {
  size: "xs",
  element: "span",
  css: {
    padding: 0
  },
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    css: {
      background: color,
      boxShadow: color != null ? 'none' : undefined
    },
    label: label,
    iconType: "empty",
    size: "s"
  })
}, label);
const CoverageOverviewLegend = () => {
  const thresholds = (0, _react.useMemo)(() => _constants.coverageOverviewCardColorThresholds.map(({
    threshold,
    color
  }, index, thresholdsMap) => /*#__PURE__*/_react.default.createElement(LegendLabel, {
    label: `${index === 0 ? `\u003E${threshold}` : `${threshold}-${thresholdsMap[index - 1].threshold}`} ${i18n.CoverageOverviewLegendRulesLabel}`,
    key: index,
    color: color
  })), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: {
      maxWidth: `${_constants.coverageOverviewLegendWidth}px`
    },
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.CoverageOverviewLegendTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("small", null, i18n.CoverageOverviewLegendSubtitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    wrap: true
  }, thresholds, /*#__PURE__*/_react.default.createElement(LegendLabel, {
    label: `0 ${i18n.CoverageOverviewLegendRulesLabel}`
  })));
};
exports.CoverageOverviewLegend = CoverageOverviewLegend;