"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewDashboard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _links_to_docs = require("../../../../common/components/links_to_docs");
var _header_page = require("../../../../common/components/header_page");
var i18n = _interopRequireWildcard(require("./translations"));
var _tactic_panel = require("./tactic_panel");
var _technique_panel_popover = require("./technique_panel_popover");
var _filters_panel = require("./filters_panel");
var _coverage_overview_dashboard_context = require("./coverage_overview_dashboard_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CoverageOverviewHeaderComponent = () => /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
  title: i18n.COVERAGE_OVERVIEW_DASHBOARD_TITLE,
  subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, i18n.CoverageOverviewDashboardInformation), " ", /*#__PURE__*/_react.default.createElement(_links_to_docs.CoverageOverviewLink, null))
});
const CoverageOverviewHeader = /*#__PURE__*/_react.default.memo(CoverageOverviewHeaderComponent);
const CoverageOverviewDashboardComponent = () => {
  const {
    state: {
      data
    }
  } = (0, _coverage_overview_dashboard_context.useCoverageOverviewDashboardContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CoverageOverviewHeader, null), /*#__PURE__*/_react.default.createElement(_filters_panel.CoverageOverviewFiltersPanel, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    className: "eui-xScroll"
  }, data === null || data === void 0 ? void 0 : data.mitreTactics.map(tactic => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `coverageOverviewTacticGroup-${tactic.id}`,
    direction: "column",
    key: tactic.id,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tactic_panel.CoverageOverviewTacticPanel, {
    tactic: tactic
  })), tactic.techniques.map((technique, techniqueKey) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: `${technique.id}-${techniqueKey}`
  }, /*#__PURE__*/_react.default.createElement(_technique_panel_popover.CoverageOverviewMitreTechniquePanelPopover, {
    technique: technique
  })))))));
};
const CoverageOverviewDashboard = CoverageOverviewDashboardComponent;
exports.CoverageOverviewDashboard = CoverageOverviewDashboard;