"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleSourceFilterLabelMap = exports.ruleSourceFilterDefaultOptions = exports.ruleActivityFilterLabelMap = exports.ruleActivityFilterDefaultOptions = exports.coverageOverviewPanelWidth = exports.coverageOverviewLegendWidth = exports.coverageOverviewFilterWidth = exports.coverageOverviewCardColorThresholds = void 0;
var _detection_engine = require("../../../../../common/api/detection_engine");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const coverageOverviewPanelWidth = 160;
exports.coverageOverviewPanelWidth = coverageOverviewPanelWidth;
const coverageOverviewLegendWidth = 380;
exports.coverageOverviewLegendWidth = coverageOverviewLegendWidth;
const coverageOverviewFilterWidth = 300;

/**
 * Rules count -> color map
 *
 * A corresponding color is applied if rules count >= a specific threshold
 */
exports.coverageOverviewFilterWidth = coverageOverviewFilterWidth;
const coverageOverviewCardColorThresholds = [{
  threshold: 10,
  color: '#00BFB3'
}, {
  threshold: 7,
  color: '#00BFB399'
}, {
  threshold: 3,
  color: '#00BFB34D'
}, {
  threshold: 1,
  color: '#00BFB326'
}];
exports.coverageOverviewCardColorThresholds = coverageOverviewCardColorThresholds;
const ruleActivityFilterDefaultOptions = [{
  label: _detection_engine.CoverageOverviewRuleActivity.Enabled
}, {
  label: _detection_engine.CoverageOverviewRuleActivity.Disabled
}];
exports.ruleActivityFilterDefaultOptions = ruleActivityFilterDefaultOptions;
const ruleActivityFilterLabelMap = {
  [_detection_engine.CoverageOverviewRuleActivity.Enabled]: i18n.CoverageOverviewEnabledRuleActivity,
  [_detection_engine.CoverageOverviewRuleActivity.Disabled]: i18n.CoverageOverviewDisabledRuleActivity
};
exports.ruleActivityFilterLabelMap = ruleActivityFilterLabelMap;
const ruleSourceFilterDefaultOptions = [{
  label: _detection_engine.CoverageOverviewRuleSource.Prebuilt
}, {
  label: _detection_engine.CoverageOverviewRuleSource.Custom
}];
exports.ruleSourceFilterDefaultOptions = ruleSourceFilterDefaultOptions;
const ruleSourceFilterLabelMap = {
  [_detection_engine.CoverageOverviewRuleSource.Prebuilt]: i18n.CoverageOverviewElasticRuleSource,
  [_detection_engine.CoverageOverviewRuleSource.Custom]: i18n.CoverageOverviewCustomRuleSource
};
exports.ruleSourceFilterLabelMap = ruleSourceFilterLabelMap;