"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActionsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _transform_actions = require("../../../../../../../common/detection_engine/transform_actions");
var _shared_imports = require("../../../../../../shared_imports");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
var _translations = require("../translations");
var _kibana = require("../../../../../../common/lib/kibana");
var _helpers = require("../../../../../../detections/pages/detection_engine/rules/helpers");
var _rule_actions_field = require("../../../../../../detections/components/rules/rule_actions_field");
var _validate_rule_actions_field = require("../../../../../../detections/containers/detection_engine/rules/validate_rule_actions_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const getFormSchema = actionTypeRegistry => ({
  actions: {
    validations: [{
      // Debounced validator not explicitly necessary here as the `RuleActionsFormData` form doesn't exhibit the same
      // behavior as the `ActionsStepRule` form outlined in https://github.com/elastic/kibana/issues/142217, however
      // additional renders are prevented so using for consistency
      validator: (0, _validate_rule_actions_field.debouncedValidateRuleActionsField)(actionTypeRegistry)
    }]
  },
  overwrite: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: _translations.bulkAddRuleActions.OVERWRITE_LABEL
  }
});
const defaultFormData = {
  actions: [],
  overwrite: false
};
const RuleActionsFormComponent = ({
  rulesCount,
  onClose,
  onConfirm
}) => {
  const {
    services: {
      triggersActionsUi: {
        actionTypeRegistry
      }
    }
  } = (0, _kibana.useKibana)();
  const formSchema = (0, _react.useMemo)(() => getFormSchema(actionTypeRegistry), [actionTypeRegistry]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: formSchema,
    defaultValue: defaultFormData
  });
  const [{
    overwrite
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['overwrite', 'throttle']
  });
  const handleSubmit = (0, _react.useCallback)(async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    const {
      actions = [],
      overwrite: overwriteValue
    } = data;
    const editAction = overwriteValue ? _rule_management.BulkActionEditTypeEnum.set_rule_actions : _rule_management.BulkActionEditTypeEnum.add_rule_actions;
    onConfirm({
      type: editAction,
      value: {
        actions: actions.map(_transform_actions.transformAlertToNormalizedRuleAction)
      }
    });
  }, [form, onConfirm]);
  const messageVariables = (0, _react.useMemo)(() => (0, _helpers.getAllActionMessageParams)(), []);
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    title: _translations.bulkAddRuleActions.FORM_TITLE,
    onClose: onClose,
    onSubmit: handleSubmit,
    flyoutSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    "data-test-subj": "bulkEditRulesRuleActionInfo",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.addRuleActions.infoCalloutTitle",
      defaultMessage: "Configure actions for {rulesCount, plural, one {# rule} other {# rules}} you\u2019ve selected",
      values: {
        rulesCount
      }
    })
  }, /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, _translations.bulkAddRuleActions.RULE_VARIABLES_DETAIL))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "actions",
    component: _rule_actions_field.RuleActionsField,
    componentProps: {
      messageVariables,
      summaryMessageVariables: messageVariables
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "overwrite",
    componentProps: {
      idAria: 'bulkEditRulesOverwriteRuleActions',
      'data-test-subj': 'bulkEditRulesOverwriteRuleActions'
    }
  }), overwrite && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    "data-test-subj": "bulkEditRulesRuleActionsWarning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.addRuleActions.warningCalloutMessage",
    defaultMessage: "You're about to overwrite rule actions for {rulesCount, plural, one {# selected rule} other {# selected rules}}. Click {saveButton} to apply changes.",
    values: {
      rulesCount,
      saveButton: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.addRuleActions.warningCalloutMessage.buttonLabel",
        defaultMessage: "Save"
      }))
    }
  }))));
};
const RuleActionsForm = /*#__PURE__*/_react.default.memo(RuleActionsFormComponent);
exports.RuleActionsForm = RuleActionsForm;
RuleActionsForm.displayName = 'RuleActionsForm';