"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPrebuiltRulesTableFilters = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _tags_filter_popover = require("../rules_table_filters/tags_filter_popover");
var _rule_search_field = require("../rules_table_filters/rule_search_field");
var _add_prebuilt_rules_table_context = require("./add_prebuilt_rules_table_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeM};
`;

/**
 * Collection of filters for filtering data within the Add Prebuilt Rules table.
 * Contains search bar and tag selection
 */
const AddPrebuiltRulesTableFiltersComponent = () => {
  const {
    state: {
      filterOptions,
      tags
    },
    actions: {
      setFilterOptions
    }
  } = (0, _add_prebuilt_rules_table_context.useAddPrebuiltRulesTableContext)();
  const {
    tags: selectedTags
  } = filterOptions;
  const handleOnSearch = (0, _react.useCallback)(filterString => {
    setFilterOptions(filters => ({
      ...filters,
      filter: filterString.trim()
    }));
  }, [setFilterOptions]);
  const handleSelectedTags = (0, _react.useCallback)(newTags => {
    if (!(0, _fp.isEqual)(newTags, selectedTags)) {
      setFilterOptions(filters => ({
        ...filters,
        tags: newTags
      }));
    }
  }, [selectedTags, setFilterOptions]);
  return /*#__PURE__*/_react.default.createElement(FilterWrapper, {
    gutterSize: "m",
    justifyContent: "flexEnd",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_rule_search_field.RuleSearchField, {
    initialValue: filterOptions.filter,
    onSearch: handleOnSearch,
    placeholder: i18n.SEARCH_PLACEHOLDER
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_tags_filter_popover.TagsFilterPopover, {
    onSelectedTagsChanged: handleSelectedTags,
    selectedTags: selectedTags,
    tags: tags,
    "data-test-subj": "allRulesTagPopover"
  }))));
};
AddPrebuiltRulesTableFiltersComponent.displayName = 'AddPrebuiltRulesTableFiltersComponent';
const AddPrebuiltRulesTableFilters = /*#__PURE__*/_react.default.memo(AddPrebuiltRulesTableFiltersComponent);
exports.AddPrebuiltRulesTableFilters = AddPrebuiltRulesTableFilters;
AddPrebuiltRulesTableFilters.displayName = 'AddPrebuiltRulesTableFilters';