"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleUpdateCallouts = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../app/types");
var _links = require("../../../../common/components/links");
var _kibana = require("../../../../common/lib/kibana");
var _use_prebuilt_rules_status = require("../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_status");
var _mini_callout = require("../mini_callout/mini_callout");
var _translations = require("../mini_callout/translations");
var _rules_table_toolbar = require("../rules_table/rules_table_toolbar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleUpdateCallouts = () => {
  var _prebuiltRulesStatus$, _prebuiltRulesStatus$2;
  const {
    data: prebuiltRulesStatus
  } = (0, _use_prebuilt_rules_status.usePrebuiltRulesStatus)();
  const rulesToInstallCount = (_prebuiltRulesStatus$ = prebuiltRulesStatus === null || prebuiltRulesStatus === void 0 ? void 0 : prebuiltRulesStatus.num_prebuilt_rules_to_install) !== null && _prebuiltRulesStatus$ !== void 0 ? _prebuiltRulesStatus$ : 0;
  const rulesToUpgradeCount = (_prebuiltRulesStatus$2 = prebuiltRulesStatus === null || prebuiltRulesStatus === void 0 ? void 0 : prebuiltRulesStatus.num_prebuilt_rules_to_upgrade) !== null && _prebuiltRulesStatus$2 !== void 0 ? _prebuiltRulesStatus$2 : 0;

  // Check against rulesInstalledCount since we don't want to show banners if we're showing the empty prompt
  const shouldDisplayNewRulesCallout = rulesToInstallCount > 0;
  const shouldDisplayUpdateRulesCallout = rulesToUpgradeCount > 0;
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  const {
    href
  } = getSecuritySolutionLinkProps({
    deepLinkId: _types.SecurityPageName.rules,
    path: _rules_table_toolbar.AllRulesTabs.updates
  });
  const {
    application: {
      navigateToUrl
    }
  } = (0, _kibana.useKibana)().services;
  const updateCallOutOnClick = (0, _react.useCallback)(() => {
    navigateToUrl(href);
  }, [navigateToUrl, href]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, shouldDisplayUpdateRulesCallout && /*#__PURE__*/_react.default.createElement(_mini_callout.MiniCallout, {
    iconType: 'iInCircle',
    "data-test-subj": "prebuilt-rules-update-callout",
    title: (0, _translations.getUpdateRulesCalloutTitle)(updateCallOutOnClick)
  }), shouldDisplayNewRulesCallout && /*#__PURE__*/_react.default.createElement(_mini_callout.MiniCallout, {
    color: "success",
    "data-test-subj": "prebuilt-rules-new-callout",
    iconType: 'iInCircle',
    title: _translations.NEW_PREBUILT_RULES_AVAILABLE_CALLOUT_TITLE
  }));
};
exports.RuleUpdateCallouts = RuleUpdateCallouts;