"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortingOptions = exports.PaginationOptions = void 0;
var z = _interopRequireWildcard(require("zod"));
var _detection_engine = require("../../../../common/api/detection_engine");
var _rule_management = require("../../../../common/api/detection_engine/rule_management");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PaginationOptions = z.object({
  page: z.number().int().min(0),
  perPage: z.number().int().min(0),
  total: z.number().int().min(0)
});

// Rule snooze settings map keyed by rule SO's id (not ruleId) and valued by rule snooze settings
exports.PaginationOptions = PaginationOptions;
const SortingOptions = z.object({
  field: _rule_management.FindRulesSortField,
  order: _detection_engine.SortOrder
});
exports.SortingOptions = SortingOptions;