"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATED_VERSION_DESCRIPTION = exports.UPDATED_VERSION = exports.EXPAND_UNCHANGED_LINES = exports.BASE_VERSION_DESCRIPTION = exports.BASE_VERSION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXPAND_UNCHANGED_LINES = linesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.expandHiddenDiffLinesLabel', {
  values: {
    linesCount
  },
  defaultMessage: 'Expand {linesCount} unchanged {linesCount, plural, one {line} other {lines}}'
});
exports.EXPAND_UNCHANGED_LINES = EXPAND_UNCHANGED_LINES;
const BASE_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.baseVersionLabel', {
  defaultMessage: 'Base version'
});
exports.BASE_VERSION = BASE_VERSION;
const BASE_VERSION_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.baseVersionDescriptionLabel', {
  defaultMessage: 'Shows currently installed rule'
});
exports.BASE_VERSION_DESCRIPTION = BASE_VERSION_DESCRIPTION;
const UPDATED_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.updatedVersionLabel', {
  defaultMessage: 'Update'
});
exports.UPDATED_VERSION = UPDATED_VERSION;
const UPDATED_VERSION_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.updatedVersionDescriptionLabel', {
  defaultMessage: 'Shows rule that will be installed'
});
exports.UPDATED_VERSION_DESCRIPTION = UPDATED_VERSION_DESCRIPTION;