"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFetchPrebuiltRulesInstallReviewQuery = exports.useFetchPrebuiltRulesInstallReviewQuery = exports.REVIEW_RULE_INSTALLATION_QUERY_KEY = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _api = require("../../api");
var _urls = require("../../../../../../common/api/detection_engine/prebuilt_rules/urls");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REVIEW_RULE_INSTALLATION_QUERY_KEY = ['POST', _urls.REVIEW_RULE_INSTALLATION_URL];
exports.REVIEW_RULE_INSTALLATION_QUERY_KEY = REVIEW_RULE_INSTALLATION_QUERY_KEY;
const useFetchPrebuiltRulesInstallReviewQuery = options => {
  return (0, _reactQuery.useQuery)(REVIEW_RULE_INSTALLATION_QUERY_KEY, async ({
    signal
  }) => {
    const response = await (0, _api.reviewRuleInstall)({
      signal
    });
    return response;
  }, {
    ..._constants.DEFAULT_QUERY_OPTIONS,
    ...options
  });
};

/**
 * We should use this hook to invalidate the prebuilt rules to install cache. For
 * example, rule mutations that affect rule set size, like installing a rule,
 * should lead to cache invalidation.
 *
 * @returns A rules cache invalidation callback
 */
exports.useFetchPrebuiltRulesInstallReviewQuery = useFetchPrebuiltRulesInstallReviewQuery;
const useInvalidateFetchPrebuiltRulesInstallReviewQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(REVIEW_RULE_INSTALLATION_QUERY_KEY, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFetchPrebuiltRulesInstallReviewQuery = useInvalidateFetchPrebuiltRulesInstallReviewQuery;