"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GO_TO_EXCEPTIONS = exports.ADD_TO_LISTS_OPTION_TOOLTIP = exports.ADD_TO_LISTS_OPTION_DISABLED_TOOLTIP = exports.ADD_TO_LISTS_OPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TO_LISTS_OPTION = _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.flyoutComponents.addToListsOptions.addToListsOptionLabel', {
  defaultMessage: 'Add to shared exception lists'
});
exports.ADD_TO_LISTS_OPTION = ADD_TO_LISTS_OPTION;
const GO_TO_EXCEPTIONS = _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.flyoutComponents.addToListsOptions.gotToSharedExceptions', {
  defaultMessage: 'Manage shared exception lists'
});
exports.GO_TO_EXCEPTIONS = GO_TO_EXCEPTIONS;
const ADD_TO_LISTS_OPTION_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.flyoutComponents.addToListsOptions.addToListsTooltip', {
  defaultMessage: 'Shared exception list is a group of exceptions. Select this option if you’d like to add this exception to shared exception lists.'
});
exports.ADD_TO_LISTS_OPTION_TOOLTIP = ADD_TO_LISTS_OPTION_TOOLTIP;
const ADD_TO_LISTS_OPTION_DISABLED_TOOLTIP = rulesCount => _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.flyoutComponents.addToListsOptions.addToListsTooltipTitle', {
  values: {
    rulesCount
  },
  defaultMessage: 'Shared exception list is a group of exceptions shared across rules. {rulesCount, plural, =1 {This rule currently has no shared} other {These rules currently have no commonly shared}} exception lists attached. To create one, visit the Shared Exception Lists page.'
});
exports.ADD_TO_LISTS_OPTION_DISABLED_TOOLTIP = ADD_TO_LISTS_OPTION_DISABLED_TOOLTIP;