"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialState = exports.createExceptionItemsReducer = void 0;
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  initialItems: [],
  exceptionItems: [],
  exceptionItemMeta: {
    name: ''
  },
  newComment: '',
  commentErrorExists: false,
  itemConditionValidationErrorExists: false,
  closeSingleAlert: false,
  bulkCloseAlerts: false,
  disableBulkClose: false,
  bulkCloseIndex: undefined,
  selectedOs: undefined,
  exceptionListsToAddTo: [],
  addExceptionToRadioSelection: 'add_to_rule',
  selectedRulesToAddTo: [],
  listType: _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT,
  errorSubmitting: null,
  expireTime: undefined,
  expireErrorExists: false
};
exports.initialState = initialState;
const createExceptionItemsReducer = () => /* eslint complexity: ["error", 21]*/
(state, action) => {
  switch (action.type) {
    case 'setExceptionItemMeta':
      {
        const {
          value
        } = action;
        return {
          ...state,
          exceptionItemMeta: {
            ...state.exceptionItemMeta,
            [value[0]]: value[1]
          }
        };
      }
    case 'setInitialExceptionItems':
      {
        const {
          items
        } = action;
        return {
          ...state,
          initialItems: items
        };
      }
    case 'setExceptionItems':
      {
        const {
          items
        } = action;
        return {
          ...state,
          exceptionItems: items
        };
      }
    case 'setConditionValidationErrorExists':
      {
        const {
          errorExists
        } = action;
        return {
          ...state,
          itemConditionValidationErrorExists: errorExists
        };
      }
    case 'setComment':
      {
        const {
          comment
        } = action;
        return {
          ...state,
          newComment: comment
        };
      }
    case 'setCommentError':
      {
        const {
          errorExists
        } = action;
        return {
          ...state,
          commentErrorExists: errorExists
        };
      }
    case 'setCloseSingleAlert':
      {
        const {
          close
        } = action;
        return {
          ...state,
          closeSingleAlert: close
        };
      }
    case 'setBulkCloseAlerts':
      {
        const {
          bulkClose
        } = action;
        return {
          ...state,
          bulkCloseAlerts: bulkClose
        };
      }
    case 'setBulkCloseIndex':
      {
        const {
          bulkCloseIndex
        } = action;
        return {
          ...state,
          bulkCloseIndex
        };
      }
    case 'setSelectedOsOptions':
      {
        const {
          selectedOs
        } = action;
        return {
          ...state,
          selectedOs
        };
      }
    case 'setAddExceptionToLists':
      {
        const {
          listsToAddTo
        } = action;
        return {
          ...state,
          exceptionListsToAddTo: listsToAddTo
        };
      }
    case 'setListOrRuleRadioOption':
      {
        const {
          option
        } = action;
        return {
          ...state,
          addExceptionToRadioSelection: option,
          listType: option === 'add_to_lists' ? _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION : _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT,
          selectedRulesToAddTo: option === 'add_to_lists' ? [] : state.selectedRulesToAddTo
        };
      }
    case 'setSelectedRulesToAddTo':
      {
        const {
          rules
        } = action;
        return {
          ...state,
          selectedRulesToAddTo: rules
        };
      }
    case 'setListType':
      {
        const {
          listType
        } = action;
        return {
          ...state,
          listType
        };
      }
    case 'setDisableBulkCloseAlerts':
      {
        const {
          disableBulkCloseAlerts
        } = action;
        return {
          ...state,
          disableBulkClose: disableBulkCloseAlerts
        };
      }
    case 'setErrorSubmitting':
      {
        const {
          err
        } = action;
        return {
          ...state,
          errorSubmitting: err
        };
      }
    case 'setExpireTime':
      {
        const {
          expireTime
        } = action;
        return {
          ...state,
          expireTime
        };
      }
    case 'setExpireError':
      {
        const {
          errorExists
        } = action;
        return {
          ...state,
          expireErrorExists: errorExists
        };
      }
    default:
      return state;
  }
};
exports.createExceptionItemsReducer = createExceptionItemsReducer;