"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TABLE_TITLE = exports.TABLE_SUBTITLE = exports.SHOWING_EXECUTIONS = exports.RULE_EXECUTION_LOG_SHOW_METRIC_COLUMNS_SWITCH = exports.RULE_EXECUTION_LOG_SEARCH_PLACEHOLDER = exports.RULE_EXECUTION_LOG_SEARCH_LIMIT_EXCEEDED = exports.ROW_DETAILS_MESSAGE = exports.GREATER_THAN_YEAR = exports.EXPAND_ROW = exports.EXPAND = exports.DURATION_NOT_AVAILABLE = exports.COLUMN_TIMESTAMP_TOOLTIP = exports.COLUMN_TIMESTAMP = exports.COLUMN_STATUS_TOOLTIP = exports.COLUMN_STATUS = exports.COLUMN_SEARCH_DURATION_TOOLTIP = exports.COLUMN_SEARCH_DURATION = exports.COLUMN_SCHEDULING_DELAY_TOOLTIP = exports.COLUMN_SCHEDULING_DELAY = exports.COLUMN_MESSAGE_TOOLTIP = exports.COLUMN_MESSAGE = exports.COLUMN_INDEX_DURATION_TOOLTIP = exports.COLUMN_INDEX_DURATION = exports.COLUMN_GAP_TOOLTIP_SEE_DOCUMENTATION = exports.COLUMN_GAP_DURATION = exports.COLUMN_DURATION_TOOLTIP = exports.COLUMN_DURATION = exports.COLUMN_ACTIONS_TOOLTIP = exports.COLUMN_ACTIONS = exports.COLLAPSE = exports.ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_TITLE = exports.ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_RESTORE_BUTTON = exports.ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_DESCRIPTION = exports.ACTIONS_FIELD_NOT_FOUND_ERROR_TITLE = exports.ACTIONS_FIELD_NOT_FOUND_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TABLE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.tableTitle', {
  defaultMessage: 'Execution log'
});
exports.TABLE_TITLE = TABLE_TITLE;
const TABLE_SUBTITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.tableSubtitle', {
  defaultMessage: 'A log of rule execution results'
});
exports.TABLE_SUBTITLE = TABLE_SUBTITLE;
const SHOWING_EXECUTIONS = totalItems => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.totalExecutionsLabel', {
  values: {
    totalItems
  },
  defaultMessage: 'Showing {totalItems} {totalItems, plural, =1 {rule execution} other {rule executions}}'
});
exports.SHOWING_EXECUTIONS = SHOWING_EXECUTIONS;
const RULE_EXECUTION_LOG_SEARCH_LIMIT_EXCEEDED = (totalItems, maxItems) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.searchLimitExceededLabel', {
  values: {
    totalItems,
    maxItems
  },
  defaultMessage: "More than {totalItems} rule executions match filters provided. Showing first {maxItems} by most recent '@timestamp'. Constrain filters further to view additional execution events."
});
exports.RULE_EXECUTION_LOG_SEARCH_LIMIT_EXCEEDED = RULE_EXECUTION_LOG_SEARCH_LIMIT_EXCEEDED;
const RULE_EXECUTION_LOG_SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.searchPlaceholder', {
  defaultMessage: 'duration > 100 and gapDuration > 10'
});
exports.RULE_EXECUTION_LOG_SEARCH_PLACEHOLDER = RULE_EXECUTION_LOG_SEARCH_PLACEHOLDER;
const RULE_EXECUTION_LOG_SHOW_METRIC_COLUMNS_SWITCH = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.showMetricColumnsSwitchTitle', {
  defaultMessage: 'Show metrics columns'
});
exports.RULE_EXECUTION_LOG_SHOW_METRIC_COLUMNS_SWITCH = RULE_EXECUTION_LOG_SHOW_METRIC_COLUMNS_SWITCH;
const COLUMN_STATUS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.statusColumn', {
  defaultMessage: 'Status'
});
exports.COLUMN_STATUS = COLUMN_STATUS;
const COLUMN_STATUS_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.statusColumnTooltip', {
  defaultMessage: 'Overall status of execution.'
});
exports.COLUMN_STATUS_TOOLTIP = COLUMN_STATUS_TOOLTIP;
const COLUMN_TIMESTAMP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.timestampColumn', {
  defaultMessage: 'Timestamp'
});
exports.COLUMN_TIMESTAMP = COLUMN_TIMESTAMP;
const COLUMN_TIMESTAMP_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.timestampColumnTooltip', {
  defaultMessage: 'Datetime rule execution initiated.'
});
exports.COLUMN_TIMESTAMP_TOOLTIP = COLUMN_TIMESTAMP_TOOLTIP;
const COLUMN_DURATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.durationColumn', {
  defaultMessage: 'Duration'
});
exports.COLUMN_DURATION = COLUMN_DURATION;
const COLUMN_DURATION_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.durationColumnTooltip', {
  defaultMessage: 'The length of time it took for the rule to run (hh:mm:ss:SSS).'
});
exports.COLUMN_DURATION_TOOLTIP = COLUMN_DURATION_TOOLTIP;
const COLUMN_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.messageColumn', {
  defaultMessage: 'Message'
});
exports.COLUMN_MESSAGE = COLUMN_MESSAGE;
const COLUMN_MESSAGE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.messageColumnTooltip', {
  defaultMessage: 'Relevant message from execution outcome.'
});
exports.COLUMN_MESSAGE_TOOLTIP = COLUMN_MESSAGE_TOOLTIP;
const COLUMN_GAP_DURATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.gapDurationColumn', {
  defaultMessage: 'Gap Duration'
});
exports.COLUMN_GAP_DURATION = COLUMN_GAP_DURATION;
const COLUMN_GAP_TOOLTIP_SEE_DOCUMENTATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.gapTooltipSeeDocsDescription', {
  defaultMessage: 'see documentation'
});
exports.COLUMN_GAP_TOOLTIP_SEE_DOCUMENTATION = COLUMN_GAP_TOOLTIP_SEE_DOCUMENTATION;
const COLUMN_INDEX_DURATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.indexDurationColumn', {
  defaultMessage: 'Index Duration'
});
exports.COLUMN_INDEX_DURATION = COLUMN_INDEX_DURATION;
const COLUMN_INDEX_DURATION_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.indexDurationColumnTooltip', {
  defaultMessage: 'The length of time it took to index detected alerts (hh:mm:ss:SSS).'
});
exports.COLUMN_INDEX_DURATION_TOOLTIP = COLUMN_INDEX_DURATION_TOOLTIP;
const COLUMN_SEARCH_DURATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.searchDurationColumn', {
  defaultMessage: 'Search Duration'
});
exports.COLUMN_SEARCH_DURATION = COLUMN_SEARCH_DURATION;
const COLUMN_SEARCH_DURATION_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.searchDurationColumnTooltip', {
  defaultMessage: 'The length of time it took to search for alerts (hh:mm:ss:SSS).'
});
exports.COLUMN_SEARCH_DURATION_TOOLTIP = COLUMN_SEARCH_DURATION_TOOLTIP;
const COLUMN_SCHEDULING_DELAY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.schedulingDelayColumn', {
  defaultMessage: 'Scheduling Delay'
});
exports.COLUMN_SCHEDULING_DELAY = COLUMN_SCHEDULING_DELAY;
const COLUMN_SCHEDULING_DELAY_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.schedulingDelayColumnTooltip', {
  defaultMessage: 'The length of time from rule scheduled till rule executed (hh:mm:ss:SSS).'
});
exports.COLUMN_SCHEDULING_DELAY_TOOLTIP = COLUMN_SCHEDULING_DELAY_TOOLTIP;
const COLUMN_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.actionsColumn', {
  defaultMessage: 'Actions'
});
exports.COLUMN_ACTIONS = COLUMN_ACTIONS;
const COLUMN_ACTIONS_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.actionsColumnTooltip', {
  defaultMessage: 'Filter alerts by rule execution ID.'
});
exports.COLUMN_ACTIONS_TOOLTIP = COLUMN_ACTIONS_TOOLTIP;
const ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.actionSearchFiltersUpdatedTitle', {
  defaultMessage: 'Global search filters have been updated'
});
exports.ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_TITLE = ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_TITLE;
const ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.actionSearchFiltersUpdatedDescription', {
  defaultMessage: 'Search filters have been updated to show alerts from selected rule execution'
});
exports.ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_DESCRIPTION = ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_DESCRIPTION;
const ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_RESTORE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.actionSearchFiltersUpdatedRestoreButtonTitle', {
  defaultMessage: 'Restore previous filters'
});
exports.ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_RESTORE_BUTTON = ACTIONS_SEARCH_FILTERS_HAVE_BEEN_UPDATED_RESTORE_BUTTON;
const ACTIONS_FIELD_NOT_FOUND_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.actionFieldNotFoundErrorTitle', {
  defaultMessage: 'Unable to filter alerts'
});
exports.ACTIONS_FIELD_NOT_FOUND_ERROR_TITLE = ACTIONS_FIELD_NOT_FOUND_ERROR_TITLE;
const ACTIONS_FIELD_NOT_FOUND_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.actionFieldNotFoundErrorDescription', {
  defaultMessage: "Cannot find field 'kibana.alert.rule.execution.uuid' in alerts index."
});
exports.ACTIONS_FIELD_NOT_FOUND_ERROR = ACTIONS_FIELD_NOT_FOUND_ERROR;
const DURATION_NOT_AVAILABLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.durationNotAvailableDescription', {
  defaultMessage: 'N/A'
});
exports.DURATION_NOT_AVAILABLE = DURATION_NOT_AVAILABLE;
const GREATER_THAN_YEAR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.durationGreaterThanYearDescription', {
  defaultMessage: '> 1 Year'
});
exports.GREATER_THAN_YEAR = GREATER_THAN_YEAR;
const ROW_DETAILS_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.fullMessage', {
  defaultMessage: 'Full message'
});
exports.ROW_DETAILS_MESSAGE = ROW_DETAILS_MESSAGE;
const EXPAND_ROW = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.expandRow', {
  defaultMessage: 'Expand rows'
});
exports.EXPAND_ROW = EXPAND_ROW;
const EXPAND = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.expand', {
  defaultMessage: 'Expand'
});
exports.EXPAND = EXPAND;
const COLLAPSE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.collapse', {
  defaultMessage: 'Collapse'
});
exports.COLLAPSE = COLLAPSE;