"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMessageColumn = exports.getExecutionLogMetricsColumns = exports.expanderColumn = exports.EXECUTION_LOG_COLUMNS = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _empty_value = require("../../../../../common/components/empty_value");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _rule_monitoring = require("../../../../rule_monitoring");
var _popover_tooltip = require("../../../../rule_management_ui/components/rules_table/popover_tooltip");
var _table_header_tooltip_cell = require("../../../../rule_management_ui/components/rules_table/table_header_tooltip_cell");
var _rule_duration_format = require("./rule_duration_format");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const expanderColumn = ({
  toggleRowExpanded,
  isRowExpanded
}) => {
  return {
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, i18n.EXPAND_ROW)),
    render: item => item.security_status === 'succeeded' ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => toggleRowExpanded(item),
      "aria-label": isRowExpanded(item) ? i18n.COLLAPSE : i18n.EXPAND,
      iconType: isRowExpanded(item) ? 'arrowUp' : 'arrowDown'
    })
  };
};
exports.expanderColumn = expanderColumn;
const EXECUTION_LOG_COLUMNS = [{
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_STATUS,
    tooltipContent: i18n.COLUMN_STATUS_TOOLTIP
  }),
  field: 'security_status',
  render: value => /*#__PURE__*/_react.default.createElement(_rule_monitoring.ExecutionStatusIndicator, {
    status: value,
    showTooltip: true
  }),
  sortable: false,
  truncateText: false,
  width: '10%'
}, {
  field: 'timestamp',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_TIMESTAMP,
    tooltipContent: i18n.COLUMN_TIMESTAMP_TOOLTIP
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
    value: value,
    fieldName: "timestamp"
  }),
  sortable: true,
  truncateText: false,
  width: '15%'
}, {
  field: 'duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_DURATION,
    tooltipContent: i18n.COLUMN_DURATION_TOOLTIP
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value ? /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
    duration: value
  }) : (0, _empty_value.getEmptyValue)()),
  sortable: true,
  truncateText: false,
  width: '10%'
}];
exports.EXECUTION_LOG_COLUMNS = EXECUTION_LOG_COLUMNS;
const getMessageColumn = width => ({
  field: 'security_message',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_MESSAGE,
    tooltipContent: i18n.COLUMN_MESSAGE_TOOLTIP
  }),
  render: (value, record) => {
    if (record.security_status === 'succeeded') {
      return value;
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
          display: -webkit-box;
          -webkit-line-clamp: 3;
          -webkit-box-orient: vertical;
          overflow: hidden;
        `
    }, value);
  },
  sortable: false,
  width
});
exports.getMessageColumn = getMessageColumn;
const getExecutionLogMetricsColumns = docLinks => [{
  field: 'gap_duration_s',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_GAP_DURATION,
    customTooltip: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        maxWidth: '20px'
      }
    }, /*#__PURE__*/_react.default.createElement(_popover_tooltip.PopoverTooltip, {
      columnName: i18n.COLUMN_GAP_DURATION
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 's',
      style: {
        width: 350
      }
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Duration of gap in Rule execution (hh:mm:ss:SSS). Adjust Rule look-back or {seeDocs} for mitigating gaps.",
      id: "xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.gapDurationColumnTooltip",
      values: {
        seeDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: `${docLinks.links.siem.troubleshootGaps}`,
          target: "_blank"
        }, i18n.COLUMN_GAP_TOOLTIP_SEE_DOCUMENTATION)
      }
    })))))
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value ? /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
    duration: value,
    isSeconds: true
  }) : (0, _empty_value.getEmptyValue)()),
  sortable: true,
  truncateText: false,
  width: '10%'
}, {
  field: 'indexing_duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_INDEX_DURATION,
    tooltipContent: i18n.COLUMN_INDEX_DURATION_TOOLTIP
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value ? /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
    duration: value
  }) : (0, _empty_value.getEmptyValue)()),
  sortable: true,
  truncateText: false,
  width: '10%'
}, {
  field: 'search_duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_SEARCH_DURATION,
    tooltipContent: i18n.COLUMN_SEARCH_DURATION_TOOLTIP
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value ? /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
    duration: value
  }) : (0, _empty_value.getEmptyValue)()),
  sortable: true,
  truncateText: false,
  width: '10%'
}, {
  field: 'schedule_delay_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_SCHEDULING_DELAY,
    tooltipContent: i18n.COLUMN_SCHEDULING_DELAY_TOOLTIP
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value ? /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
    duration: value
  }) : (0, _empty_value.getEmptyValue)()),
  sortable: true,
  truncateText: false,
  width: '10%'
}];
exports.getExecutionLogMetricsColumns = getExecutionLogMetricsColumns;