"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_dashboard_view_prompt_state = require("../hooks/use_dashboard_view_prompt_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusPromptComponent = ({
  currentState
}) => {
  const emptyPromptProps = (0, _use_dashboard_view_prompt_state.useDashboardViewPromptState)(currentState);
  return emptyPromptProps && currentState ? /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    "data-test-subj": `dashboardViewEmpty${currentState}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, emptyPromptProps)) : null;
};
StatusPromptComponent.displayName = 'StatusPromptComponent';
const StatusPrompt = /*#__PURE__*/_react.default.memo(StatusPromptComponent);
exports.StatusPrompt = StatusPrompt;