"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppRootProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _reactQuery = require("@tanstack/react-query");
var _upselling_provider = require("../../components/upselling_provider");
var _console = require("../../../management/components/console");
var _mock_assistant_provider = require("../mock_assistant_provider");
var _route_capture = require("../../components/endpoint/route_capture");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides the context for rendering the endpoint app
 */
const AppRootProvider = /*#__PURE__*/(0, _react.memo)(({
  store,
  history,
  coreStart,
  depsStart: {
    data
  },
  queryClient,
  startServices,
  children
}) => {
  const {
    uiSettings
  } = coreStart;
  const isDarkMode = (0, _useObservable.default)(uiSettings.get$('theme:darkMode'));
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: startServices
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_upselling_provider.UpsellingProvider, {
    upsellingService: startServices.upselling
  }, /*#__PURE__*/_react.default.createElement(_mock_assistant_provider.MockAssistantProvider, null, /*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: coreStart
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_console.ConsoleManager, null, /*#__PURE__*/_react.default.createElement(_route_capture.RouteCapture, null, children)))))))))));
});
exports.AppRootProvider = AppRootProvider;
AppRootProvider.displayName = 'AppRootProvider';