"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INDEX_PATTERN_FETCH_FAILURE = exports.EQL_TIME_INTERVAL_NOT_DEFINED = exports.EQL_PREVIEW_FETCH_FAILURE = exports.ADDED_TO_TIMELINE_TEMPLATE_MESSAGE = exports.ADDED_TO_TIMELINE_MESSAGE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADDED_TO_TIMELINE_MESSAGE = fieldOrValue => _i18n.i18n.translate('xpack.securitySolution.hooks.useAddToTimeline.addedFieldMessage', {
  values: {
    fieldOrValue
  },
  defaultMessage: `Added {fieldOrValue} to timeline`
});
exports.ADDED_TO_TIMELINE_MESSAGE = ADDED_TO_TIMELINE_MESSAGE;
const ADDED_TO_TIMELINE_TEMPLATE_MESSAGE = fieldOrValue => _i18n.i18n.translate('xpack.securitySolution.hooks.useAddToTimeline.template.addedFieldMessage', {
  values: {
    fieldOrValue
  },
  defaultMessage: `Added {fieldOrValue} to timeline template`
});
exports.ADDED_TO_TIMELINE_TEMPLATE_MESSAGE = ADDED_TO_TIMELINE_TEMPLATE_MESSAGE;
const INDEX_PATTERN_FETCH_FAILURE = _i18n.i18n.translate('xpack.securitySolution.components.mlPopup.hooks.errors.indexPatternFetchFailureTitle', {
  defaultMessage: 'Index pattern fetch failure'
});
exports.INDEX_PATTERN_FETCH_FAILURE = INDEX_PATTERN_FETCH_FAILURE;
const EQL_PREVIEW_FETCH_FAILURE = _i18n.i18n.translate('xpack.securitySolution.components.hooks.eql.partialResponse', {
  defaultMessage: 'EQL Preview Error'
});
exports.EQL_PREVIEW_FETCH_FAILURE = EQL_PREVIEW_FETCH_FAILURE;
const EQL_TIME_INTERVAL_NOT_DEFINED = _i18n.i18n.translate('xpack.securitySolution.components.hooks.errors.timeIntervalsNotDefined', {
  defaultMessage: 'Time intervals are not defined.'
});
exports.EQL_TIME_INTERVAL_NOT_DEFINED = EQL_TIME_INTERVAL_NOT_DEFINED;