"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIQUE_COUNT = exports.TOP_VALUE = exports.SUCCESS_CHART_LABEL = exports.SOURCE_CHART_LABEL = exports.OPEN_IN_LENS = exports.MORE_ACTIONS = exports.INSPECT = exports.FAIL_CHART_LABEL = exports.DESTINATION_CHART_LABEL = exports.COUNT_OF = exports.COUNT = exports.AUTHENTICATION_SUCCESS_CHART_LABEL = exports.AUTHENTICATION_FAILURE_CHART_LABEL = exports.ADD_TO_NEW_CASE = exports.ADD_TO_EXISTING_CASE = exports.ADD_TO_CASE_SUCCESS = exports.ADDED_TO_LIBRARY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MORE_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.moreActions', {
  defaultMessage: 'More actions'
});
exports.MORE_ACTIONS = MORE_ACTIONS;
const INSPECT = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.inspect', {
  defaultMessage: 'Inspect'
});
exports.INSPECT = INSPECT;
const OPEN_IN_LENS = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.openInLens', {
  defaultMessage: 'Open in Lens'
});
exports.OPEN_IN_LENS = OPEN_IN_LENS;
const ADD_TO_NEW_CASE = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.addToNewCase', {
  defaultMessage: 'Add to new case'
});
exports.ADD_TO_NEW_CASE = ADD_TO_NEW_CASE;
const ADD_TO_EXISTING_CASE = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.addToExistingCase', {
  defaultMessage: 'Add to existing case'
});
exports.ADD_TO_EXISTING_CASE = ADD_TO_EXISTING_CASE;
const ADD_TO_CASE_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.addToCaseSuccessContent', {
  defaultMessage: 'Successfully added visualization to the case'
});
exports.ADD_TO_CASE_SUCCESS = ADD_TO_CASE_SUCCESS;
const SOURCE_CHART_LABEL = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.uniqueIps.sourceChartLabel', {
  defaultMessage: 'Src.'
});
exports.SOURCE_CHART_LABEL = SOURCE_CHART_LABEL;
const DESTINATION_CHART_LABEL = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.uniqueIps.destinationChartLabel', {
  defaultMessage: 'Dest.'
});
exports.DESTINATION_CHART_LABEL = DESTINATION_CHART_LABEL;
const SUCCESS_CHART_LABEL = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.userAuthentications.successChartLabel', {
  defaultMessage: 'Succ.'
});
exports.SUCCESS_CHART_LABEL = SUCCESS_CHART_LABEL;
const AUTHENTICATION_SUCCESS_CHART_LABEL = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.userAuthentications.authentication.successChartLabel', {
  defaultMessage: 'Success'
});
exports.AUTHENTICATION_SUCCESS_CHART_LABEL = AUTHENTICATION_SUCCESS_CHART_LABEL;
const FAIL_CHART_LABEL = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.userAuthentications.failChartLabel', {
  defaultMessage: 'Fail'
});
exports.FAIL_CHART_LABEL = FAIL_CHART_LABEL;
const AUTHENTICATION_FAILURE_CHART_LABEL = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.userAuthentications.authentication.failureChartLabel', {
  defaultMessage: 'Failure'
});
exports.AUTHENTICATION_FAILURE_CHART_LABEL = AUTHENTICATION_FAILURE_CHART_LABEL;
const UNIQUE_COUNT = field => _i18n.i18n.translate('xpack.securitySolution.visualizationActions.uniqueCountLabel', {
  values: {
    field
  },
  defaultMessage: 'Unique count of {field}'
});
exports.UNIQUE_COUNT = UNIQUE_COUNT;
const TOP_VALUE = field => _i18n.i18n.translate('xpack.securitySolution.visualizationActions.topValueLabel', {
  values: {
    field
  },
  defaultMessage: 'Top values of {field}'
});
exports.TOP_VALUE = TOP_VALUE;
const COUNT = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.countLabel', {
  defaultMessage: 'Count of records'
});
exports.COUNT = COUNT;
const COUNT_OF = field => _i18n.i18n.translate('xpack.securitySolution.visualizationActions.countOfFieldLabel', {
  values: {
    field
  },
  defaultMessage: 'Count of {field}'
});
exports.COUNT_OF = COUNT_OF;
const ADDED_TO_LIBRARY = _i18n.i18n.translate('xpack.securitySolution.visualizationActions.addedToLibrary', {
  defaultMessage: 'Added to library'
});
exports.ADDED_TO_LIBRARY = ADDED_TO_LIBRARY;