"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UtilityBarAction = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _link_icon = require("../link_icon");
var _styles = require("./styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LoadingButtonEmpty = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    &.euiButtonEmpty {
      height: ${theme.eui.euiSize};
    }
  `}
`;
const Popover = /*#__PURE__*/_react.default.memo(({
  children,
  color,
  iconSide,
  iconSize,
  iconType,
  popoverContent,
  disabled,
  ownFocus,
  dataTestSubj,
  popoverPanelPaddingSize,
  onClick
}) => {
  const [popoverState, setPopoverState] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => setPopoverState(false), [setPopoverState]);
  const handleLinkIconClick = (0, _react.useCallback)(() => {
    onClick === null || onClick === void 0 ? void 0 : onClick();
    setPopoverState(!popoverState);
  }, [popoverState, onClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: ownFocus,
    panelPaddingSize: popoverPanelPaddingSize,
    button: /*#__PURE__*/_react.default.createElement(_link_icon.LinkIcon, {
      dataTestSubj: dataTestSubj,
      color: color,
      iconSide: iconSide,
      iconSize: iconSize,
      iconType: iconType,
      disabled: disabled,
      onClick: handleLinkIconClick
    }, children),
    closePopover: closePopover,
    isOpen: popoverState,
    repositionOnScroll: true
  }, popoverContent === null || popoverContent === void 0 ? void 0 : popoverContent(closePopover));
});
Popover.displayName = 'Popover';
const UtilityBarAction = /*#__PURE__*/_react.default.memo(({
  children,
  color,
  dataTestSubj,
  disabled,
  href,
  iconSide,
  iconSize,
  iconType,
  ownFocus,
  onClick,
  popoverContent,
  popoverPanelPaddingSize,
  inProgress
}) => {
  if (inProgress) {
    return /*#__PURE__*/_react.default.createElement(_styles.BarAction, null, /*#__PURE__*/_react.default.createElement(LoadingButtonEmpty, {
      "data-test-subj": `${dataTestSubj}-progress`,
      size: "xs",
      className: "eui-alignTop",
      isLoading: true,
      iconSide: "right",
      flush: "both"
    }, children));
  }
  return /*#__PURE__*/_react.default.createElement(_styles.BarAction, {
    "data-test-subj": dataTestSubj
  }, popoverContent ? /*#__PURE__*/_react.default.createElement(Popover, {
    dataTestSubj: `${dataTestSubj}-popover`,
    disabled: disabled,
    color: color,
    iconSide: iconSide,
    iconSize: iconSize,
    iconType: iconType,
    ownFocus: ownFocus,
    popoverPanelPaddingSize: popoverPanelPaddingSize,
    popoverContent: popoverContent,
    onClick: onClick
  }, children) : /*#__PURE__*/_react.default.createElement(_link_icon.LinkIcon, {
    color: color,
    dataTestSubj: `${dataTestSubj}-linkIcon`,
    disabled: disabled,
    href: href,
    iconSide: iconSide,
    iconSize: iconSize,
    iconType: iconType,
    onClick: onClick
  }, children));
});
exports.UtilityBarAction = UtilityBarAction;
UtilityBarAction.displayName = 'UtilityBarAction';