"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NO_PRIVILEGES_PER_PAGE_MESSAGE = exports.NO_PRIVILEGES_DEFAULT_MESSAGE = exports.NO_PERMISSIONS_TITLE = exports.GO_TO_DOCUMENTATION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_PERMISSIONS_TITLE = _i18n.i18n.translate('xpack.securitySolution.noPermissionsTitle', {
  defaultMessage: 'Privileges required'
});
exports.NO_PERMISSIONS_TITLE = NO_PERMISSIONS_TITLE;
const NO_PRIVILEGES_PER_PAGE_MESSAGE = pageName => _i18n.i18n.translate('xpack.securitySolution.noPrivilegesPerPageMessage', {
  values: {
    pageName
  },
  defaultMessage: 'To view {pageName}, you must update privileges. For more information, contact your Kibana administrator.'
});
exports.NO_PRIVILEGES_PER_PAGE_MESSAGE = NO_PRIVILEGES_PER_PAGE_MESSAGE;
const NO_PRIVILEGES_DEFAULT_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.noPrivilegesDefaultMessage', {
  defaultMessage: 'To view this page, you must update privileges. For more information, contact your Kibana administrator.'
});
exports.NO_PRIVILEGES_DEFAULT_MESSAGE = NO_PRIVILEGES_DEFAULT_MESSAGE;
const GO_TO_DOCUMENTATION = _i18n.i18n.translate('xpack.securitySolution.goToDocumentationButton', {
  defaultMessage: 'View documentation'
});
exports.GO_TO_DOCUMENTATION = GO_TO_DOCUMENTATION;