"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlStateQueryParams = exports.useGetUrlStateQueryParams = void 0;
var _react = require("react");
var _global_query_string = require("../../utils/global_query_string");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUrlStateQueryParams = pageName => {
  const getUrlStateQueryParams = useGetUrlStateQueryParams();
  const urlStateQueryParams = (0, _react.useMemo)(() => getUrlStateQueryParams(pageName), [getUrlStateQueryParams, pageName]);
  return urlStateQueryParams;
};
exports.useUrlStateQueryParams = useUrlStateQueryParams;
const useGetUrlStateQueryParams = () => {
  const globalQueryString = (0, _global_query_string.useGlobalQueryString)();
  const getUrlStateQueryParams = (0, _react.useCallback)(pageName => (0, _helpers.getSearch)(pageName, globalQueryString), [globalQueryString]);
  return getUrlStateQueryParams;
};
exports.useGetUrlStateQueryParams = useGetUrlStateQueryParams;