"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineMarkDownRendererComponent = exports.TimelineMarkDownRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_timeline_click = require("../../../../utils/timeline/use_timeline_click");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../../../hooks/use_app_toasts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelineMarkDownRendererComponent = ({
  id,
  title,
  graphEventId
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const handleTimelineClick = (0, _use_timeline_click.useTimelineClick)();
  const onError = (0, _react.useCallback)((error, timelineId) => {
    addError(error, {
      title: i18n.TIMELINE_ERROR_TITLE,
      toastMessage: i18n.FAILED_TO_RETRIEVE_TIMELINE(timelineId)
    });
  }, [addError]);
  const onClickTimeline = (0, _react.useCallback)(() => handleTimelineClick(id !== null && id !== void 0 ? id : '', onError, graphEventId), [id, graphEventId, handleTimelineClick, onError]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.TIMELINE_ID(id !== null && id !== void 0 ? id : '')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClickTimeline,
    "data-test-subj": `markdown-timeline-link-${id}`
  }, title));
};
exports.TimelineMarkDownRendererComponent = TimelineMarkDownRendererComponent;
const TimelineMarkDownRenderer = /*#__PURE__*/(0, _react.memo)(TimelineMarkDownRendererComponent);
exports.TimelineMarkDownRenderer = TimelineMarkDownRenderer;