"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportDataModalComponent = exports.ImportDataModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_app_toasts = require("../../hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
var _action_connectors_warning = require("./action_connectors_warning");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Modal component for importing Rules from a json file
 */
// TODO split into two: timelines and rules
const ImportDataModalComponent = ({
  checkBoxLabel,
  closeModal,
  description,
  errorMessage,
  failedDetailed,
  importComplete,
  importData,
  showCheckBox = true,
  showExceptionsCheckBox = false,
  showActionConnectorsCheckBox = false,
  showModal,
  submitBtnText,
  subtitle,
  successMessage,
  title
}) => {
  const [selectedFiles, setSelectedFiles] = (0, _react.useState)(null);
  const [isImporting, setIsImporting] = (0, _react.useState)(false);
  const [overwrite, setOverwrite] = (0, _react.useState)(false);
  const [overwriteExceptions, setOverwriteExceptions] = (0, _react.useState)(false);
  const [overwriteActionConnectors, setOverwriteActionConnectors] = (0, _react.useState)(false);
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const [actionConnectorsWarnings, setActionConnectorsWarnings] = (0, _react.useState)([]);
  const [importedActionConnectorsCount, setImportedActionConnectorsCount] = (0, _react.useState)(0);
  const cleanupAndCloseModal = (0, _react.useCallback)(() => {
    closeModal();
    setOverwrite(false);
    setOverwriteExceptions(false);
    setOverwriteActionConnectors(false);
    setActionConnectorsWarnings([]);
  }, [closeModal, setOverwrite, setOverwriteExceptions]);
  const onImportComplete = (0, _react.useCallback)(callCleanup => {
    setIsImporting(false);
    setSelectedFiles(null);
    importComplete();
    if (callCleanup) {
      importComplete();
      cleanupAndCloseModal();
    }
  }, [cleanupAndCloseModal, importComplete]);
  const importDataCallback = (0, _react.useCallback)(async () => {
    if (selectedFiles != null) {
      setIsImporting(true);
      const abortCtrl = new AbortController();
      try {
        const {
          action_connectors_warnings: warnings,
          ...importResponse
        } = await importData({
          fileToImport: selectedFiles[0],
          overwrite,
          overwriteExceptions,
          overwriteActionConnectors,
          signal: abortCtrl.signal
        });
        const connectorsCount = importResponse.action_connectors_success_count;
        setActionConnectorsWarnings(warnings);
        setImportedActionConnectorsCount(connectorsCount);
        (0, _utils.showToasterMessage)({
          importResponse,
          exceptionsIncluded: showExceptionsCheckBox,
          actionConnectorsIncluded: showActionConnectorsCheckBox,
          successMessage,
          errorMessage,
          errorMessageDetailed: failedDetailed,
          addError,
          addSuccess
        });
        onImportComplete(!(warnings !== null && warnings !== void 0 && warnings.length));
      } catch (error) {
        cleanupAndCloseModal();
        addError(error, {
          title: errorMessage(1)
        });
      }
    }
  }, [selectedFiles, importData, overwrite, overwriteExceptions, overwriteActionConnectors, showExceptionsCheckBox, successMessage, errorMessage, failedDetailed, addError, addSuccess, showActionConnectorsCheckBox, onImportComplete, cleanupAndCloseModal]);
  const handleCloseModal = (0, _react.useCallback)(() => {
    cleanupAndCloseModal();
  }, [cleanupAndCloseModal]);
  const handleCheckboxClick = (0, _react.useCallback)(() => {
    setOverwrite(shouldOverwrite => !shouldOverwrite);
  }, []);
  const handleExceptionsCheckboxClick = (0, _react.useCallback)(() => {
    setOverwriteExceptions(shouldOverwrite => !shouldOverwrite);
  }, []);
  const handleActionConnectorsCheckboxClick = (0, _react.useCallback)(() => {
    setOverwriteActionConnectors(shouldOverwrite => !shouldOverwrite);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showModal && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: handleCloseModal,
    maxWidth: '750px'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    "data-test-subj": "rule-file-picker",
    accept: ".ndjson",
    id: "rule-file-picker",
    initialPromptText: subtitle,
    onChange: files => {
      setSelectedFiles(files && files.length > 0 ? files : null);
    },
    display: 'large',
    fullWidth: true,
    isLoading: isImporting
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_action_connectors_warning.ActionConnectorWarnings, {
    actionConnectorsWarnings: actionConnectorsWarnings,
    importedActionConnectorsCount: importedActionConnectorsCount
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), showCheckBox && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "importDataModalCheckboxLabel",
    id: "importDataModalCheckboxLabel",
    label: checkBoxLabel,
    checked: overwrite,
    onChange: handleCheckboxClick
  }), showExceptionsCheckBox && /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "importDataModalExceptionsCheckboxLabel",
    id: "importDataModalExceptionsCheckboxLabel",
    label: i18n.OVERWRITE_EXCEPTIONS_LABEL,
    checked: overwriteExceptions,
    onChange: handleExceptionsCheckboxClick
  }), showActionConnectorsCheckBox && /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "importDataModalActionConnectorsCheckbox",
    id: "importDataModalActionConnectorsCheckbox",
    label: i18n.OVERWRITE_ACTION_CONNECTORS_LABEL,
    checked: overwriteActionConnectors,
    onChange: handleActionConnectorsCheckboxClick
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleCloseModal
  }, i18n.CANCEL_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "import-data-modal-button",
    onClick: importDataCallback,
    disabled: selectedFiles == null || isImporting,
    fill: true
  }, submitBtnText))));
};
exports.ImportDataModalComponent = ImportDataModalComponent;
ImportDataModalComponent.displayName = 'ImportDataModalComponent';
const ImportDataModal = /*#__PURE__*/_react.default.memo(ImportDataModalComponent);
exports.ImportDataModal = ImportDataModal;
ImportDataModal.displayName = 'ImportDataModal';