"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YOU_ARE_IN_A_DIALOG_CONTAINING_OPTIONS = exports.HoverActions = exports.AdditionalContent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/timelines-plugin/public");
var _timeline = require("../../../../common/types/timeline");
var _keyboard_shortcut_constants = require("./keyboard_shortcut_constants");
var _use_hover_action_items = require("./use_hover_action_items");
var _types = require("../../../app/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const YOU_ARE_IN_A_DIALOG_CONTAINING_OPTIONS = fieldName => _i18n.i18n.translate('xpack.securitySolution.dragAndDrop.youAreInADialogContainingOptionsScreenReaderOnly', {
  values: {
    fieldName
  },
  defaultMessage: `You are in a dialog, containing options for field {fieldName}. Press tab to navigate options. Press escape to exit.`
});
exports.YOU_ARE_IN_A_DIALOG_CONTAINING_OPTIONS = YOU_ARE_IN_A_DIALOG_CONTAINING_OPTIONS;
const AdditionalContent = _styledComponents.default.div`
  padding: 2px;
`;
exports.AdditionalContent = AdditionalContent;
AdditionalContent.displayName = 'AdditionalContent';
const StyledHoverActionsContainer = _styledComponents.default.div`
  display: flex;

  ${props => props.$isActive ? `
    .hoverActions-active {
      .timelines__hoverActionButton,
      .securitySolution__hoverActionButton {
        opacity: 1;
      }
    }
  ` : ''}

  ${props => props.$showOwnFocus ? `
    &:focus-within {
      .timelines__hoverActionButton,
      .securitySolution__hoverActionButton {
        opacity: 1;
      }
    }

    &:hover {
      .timelines__hoverActionButton,
      .securitySolution__hoverActionButton {
        opacity: 1;
      }
    }

  .timelines__hoverActionButton,
  .securitySolution__hoverActionButton {
    opacity: ${props.$showTopN ? 1 : 0};

      &:focus {
        opacity: 1;
      }
    }
  ` : ''}
`;
const StyledHoverActionsContainerWithPaddingsAndMinWidth = (0, _styledComponents.default)(StyledHoverActionsContainer)`
  min-width: ${({
  $hiddenActionsCount
}) => `${138 - $hiddenActionsCount * 26}px`};
  padding: ${props => `0 ${props.theme.eui.euiSizeS}`};
  position: relative;
`;
/** Returns a value for the `disabled` prop of `EuiFocusTrap` */
const isFocusTrapDisabled = ({
  ownFocus,
  showTopN
}) => {
  if (showTopN) {
    return false; // we *always* want to trap focus when showing Top N
  }

  return !ownFocus;
};
const HoverActions = /*#__PURE__*/_react.default.memo(({
  additionalContent = null,
  closePopOver,
  closeTopN,
  dataProvider,
  dataType,
  draggableId,
  enableOverflowButton = false,
  applyWidthAndPadding = true,
  field,
  fieldType,
  isAggregatable,
  goGetTimelineId,
  isObjectArray,
  hideAddToTimeline = false,
  hideTopN = false,
  onFilterAdded,
  ownFocus,
  showOwnFocus = true,
  showTopN,
  scopeId,
  toggleColumn,
  toggleTopN,
  values
}) => {
  const [stKeyboardEvent, setStKeyboardEvent] = (0, _react.useState)();
  const [isActive, setIsActive] = (0, _react.useState)(false);
  const [isOverflowPopoverOpen, setIsOverflowPopoverOpen] = (0, _react.useState)(false);
  const onOverflowButtonClick = (0, _react.useCallback)(() => {
    setIsActive(prev => !prev);
    setIsOverflowPopoverOpen(!isOverflowPopoverOpen);
  }, [isOverflowPopoverOpen, setIsOverflowPopoverOpen]);
  const handleHoverActionClicked = (0, _react.useCallback)(() => {
    if (closeTopN) {
      closeTopN();
    }
    setIsActive(false);
    setIsOverflowPopoverOpen(false);
    if (closePopOver) {
      closePopOver();
    }
  }, [closePopOver, closeTopN]);
  const isInit = (0, _react.useRef)(true);
  const defaultFocusedButtonRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (isInit.current && goGetTimelineId != null && scopeId == null) {
      isInit.current = false;
      goGetTimelineId(true);
    }
  }, [goGetTimelineId, scopeId]);
  (0, _react.useEffect)(() => {
    if (ownFocus) {
      setTimeout(() => {
        var _defaultFocusedButton;
        (_defaultFocusedButton = defaultFocusedButtonRef.current) === null || _defaultFocusedButton === void 0 ? void 0 : _defaultFocusedButton.focus();
      }, 0);
    }
  }, [ownFocus]);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if (!ownFocus) {
      return;
    }
    switch (keyboardEvent.key) {
      case _keyboard_shortcut_constants.SHOW_TOP_N_KEYBOARD_SHORTCUT:
        (0, _public.stopPropagationAndPreventDefault)(keyboardEvent);
        toggleTopN();
        break;
      case 'Enter':
        break;
      case 'Escape':
        (0, _public.stopPropagationAndPreventDefault)(keyboardEvent);
        break;
      default:
        setStKeyboardEvent(keyboardEvent);
        break;
    }
  }, [ownFocus, toggleTopN]);
  const isCaseView = scopeId === _timeline.TimelineId.casePage;
  const isTimelineView = scopeId === _timeline.TimelineId.active;
  // TODO Provide a list of disabled/enabled actions as props
  const isEntityAnalyticsPage = scopeId === _types.SecurityPageName.entityAnalytics;
  const hideFilters = (0, _react.useMemo)(() => isEntityAnalyticsPage && !isTimelineView, [isTimelineView, isEntityAnalyticsPage]);
  const hiddenActionsCount = (0, _react.useMemo)(() => {
    const hiddenTopNActions = hideTopN ? 1 : 0; // hides the `Top N` button
    const hiddenFilterActions = hideFilters ? 2 : 0; // hides both the `Filter In` and `Filter out` buttons

    return hiddenTopNActions + hiddenFilterActions;
  }, [hideFilters, hideTopN]);
  const {
    overflowActionItems,
    allActionItems
  } = (0, _use_hover_action_items.useHoverActionItems)({
    dataProvider,
    dataType,
    defaultFocusedButtonRef,
    draggableId,
    enableOverflowButton: enableOverflowButton && !isCaseView,
    field,
    fieldType,
    hideFilters,
    isAggregatable,
    handleHoverActionClicked,
    hideAddToTimeline,
    hideTopN,
    isCaseView,
    isObjectArray,
    isOverflowPopoverOpen,
    onFilterAdded,
    onOverflowButtonClick,
    ownFocus,
    showTopN,
    stKeyboardEvent,
    toggleColumn,
    toggleTopN,
    values,
    scopeId
  });
  const Container = applyWidthAndPadding ? StyledHoverActionsContainerWithPaddingsAndMinWidth : StyledHoverActionsContainer;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    disabled: isFocusTrapDisabled({
      ownFocus,
      showTopN
    })
  }, /*#__PURE__*/_react.default.createElement(Container, {
    "data-test-subj": "hover-actions-container",
    onKeyDown: onKeyDown,
    $showTopN: showTopN,
    $showOwnFocus: showOwnFocus,
    $hiddenActionsCount: hiddenActionsCount,
    $isActive: isActive,
    className: isActive ? 'hoverActions-active' : ''
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", null, YOU_ARE_IN_A_DIALOG_CONTAINING_OPTIONS(field))), additionalContent != null && /*#__PURE__*/_react.default.createElement(AdditionalContent, null, additionalContent), enableOverflowButton && !isCaseView ? overflowActionItems : allActionItems));
});
exports.HoverActions = HoverActions;
HoverActions.displayName = 'HoverActions';