"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrevalenceCellRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../../../../common/types");
var _empty_value = require("../../empty_value");
var _investigate_in_timeline_button = require("./investigate_in_timeline_button");
var _use_action_cell_data_provider = require("./use_action_cell_data_provider");
var _use_alert_prevalence = require("../../../containers/alerts/use_alert_prevalence");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Renders a Prevalence cell based on a regular alert prevalence query
 */
const PrevalenceCell = ({
  data,
  eventId,
  fieldFromBrowserField,
  linkValue,
  scopeId,
  values
}) => {
  const {
    loading,
    count
  } = (0, _use_alert_prevalence.useAlertPrevalence)({
    field: data.field,
    isActiveTimelines: scopeId === _types.TimelineId.active,
    value: values,
    signalIndexName: null
  });
  const cellDataProviders = (0, _use_action_cell_data_provider.useActionCellDataProvider)({
    contextId: scopeId,
    eventId,
    field: data.field,
    fieldFormat: data.format,
    fieldFromBrowserField,
    fieldType: data.type,
    isObjectArray: data.isObjectArray,
    linkValue,
    values
  });
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  } else if (typeof count === 'number' && cellDataProviders !== null && cellDataProviders !== void 0 && cellDataProviders.dataProviders && cellDataProviders !== null && cellDataProviders !== void 0 && cellDataProviders.dataProviders.length) {
    return /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_button.InvestigateInTimelineButton, {
      asEmptyButton: true,
      dataProviders: cellDataProviders.dataProviders,
      filters: cellDataProviders.filters
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "alert-prevalence"
    }, count));
  } else {
    return (0, _empty_value.getEmptyTagValue)();
  }
};
PrevalenceCell.displayName = 'PrevalenceCell';
const PrevalenceCellRenderer = data => /*#__PURE__*/_react.default.createElement(PrevalenceCell, data);
exports.PrevalenceCellRenderer = PrevalenceCellRenderer;