"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrichmentAccordionGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _helpers = require("./helpers");
var _enrichment_button_content = require("./enrichment_button_content");
var _threat_summary_title = require("./threat_summary_title");
var _inspect = require("../../inspect");
var _event_enrichment = require("../../../containers/cti/event_enrichment");
var i18n = _interopRequireWildcard(require("./translations"));
var _threat_summary_table = require("./threat_summary_table");
var _constants = require("../../../../../common/cti/constants");
var _constants2 = require("../../../../../common/constants");
var _data_retrieval = require("../../../../../common/utils/data_retrieval");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  .euiAccordion__triggerWrapper {
    background: ${({
  theme
}) => theme.eui.euiColorLightestShade};
    border-radius: ${({
  theme
}) => theme.eui.euiSizeXS};
    height: ${({
  theme
}) => theme.eui.euiSizeXL};
    margin-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
    padding-left: ${({
  theme
}) => theme.eui.euiSizeS};
  }
`;
const ThreatDetailsDescription = ({
  fieldName,
  value
}) => {
  const tooltipChild = fieldName.match(_constants.REFERENCE) ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: value,
    target: "_blank"
  }, value) : /*#__PURE__*/_react.default.createElement("span", null, value);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "message-tool-tip",
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("span", null, fieldName)))
  }, tooltipChild);
};
const columns = [{
  field: 'title',
  truncateText: false,
  render: _threat_summary_title.ThreatSummaryTitle,
  width: '220px',
  name: ''
}, {
  field: 'description',
  truncateText: false,
  render: ThreatDetailsDescription,
  name: ''
}];
const buildThreatDetailsItems = enrichment => Object.keys(enrichment).sort().map(field => ({
  title: field.startsWith(_constants2.DEFAULT_INDICATOR_SOURCE_PATH) ? field.replace(`${_constants2.DEFAULT_INDICATOR_SOURCE_PATH}`, 'indicator') : field,
  description: {
    fieldName: field,
    value: (0, _data_retrieval.getFirstElement)(enrichment[field])
  }
}));
const EnrichmentAccordion = ({
  enrichment,
  index
}) => {
  const {
    id = `threat-details-item`,
    field,
    feedName,
    type,
    value
  } = (0, _helpers.getEnrichmentIdentifiers)(enrichment);
  const accordionId = `${id}${field}`;
  return /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: accordionId,
    key: accordionId,
    initialIsOpen: true,
    arrowDisplay: "right",
    buttonContent: /*#__PURE__*/_react.default.createElement(_enrichment_button_content.EnrichmentButtonContent, {
      field: field,
      feedName: feedName,
      value: value
    }),
    extraAction: (0, _helpers.isInvestigationTimeEnrichment)(type) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
      queryId: _event_enrichment.QUERY_ID,
      title: i18n.INVESTIGATION_QUERY_TITLE
    }))
  }, /*#__PURE__*/_react.default.createElement(_threat_summary_table.ThreatSummaryTable, {
    columns: columns,
    compressed: true,
    "data-test-subj": `threat-details-view-${index}`,
    items: buildThreatDetailsItems(enrichment)
  }));
};
const EnrichmentAccordionGroup = ({
  enrichments
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, enrichments.sort((a, b) => (0, _helpers.getFirstSeen)(b) - (0, _helpers.getFirstSeen)(a)).map((enrichment, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
  key: `${enrichment.id}`
}, /*#__PURE__*/_react.default.createElement(EnrichmentAccordion, {
  enrichment: enrichment,
  index: index
}), index < enrichments.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}))));
exports.EnrichmentAccordionGroup = EnrichmentAccordionGroup;