"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssigneesPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _assignees_apply_panel = require("./assignees_apply_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The popover to allow selection of users from a list
 */
const AssigneesPopover = /*#__PURE__*/(0, _react.memo)(({
  assignedUserIds,
  showUnassignedOption,
  button,
  isPopoverOpen,
  closePopover,
  onSelectionChange,
  onAssigneesApply
}) => {
  const searchInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'searchInput'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    initialFocus: `#${searchInputId}`,
    button: button,
    isOpen: isPopoverOpen,
    panelStyle: {
      minWidth: _constants.ASSIGNEES_PANEL_WIDTH
    },
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_assignees_apply_panel.AssigneesApplyPanel, {
    searchInputId: searchInputId,
    assignedUserIds: assignedUserIds,
    showUnassignedOption: showUnassignedOption,
    onSelectionChange: onSelectionChange,
    onAssigneesApply: onAssigneesApply
  }));
});
exports.AssigneesPopover = AssigneesPopover;
AssigneesPopover.displayName = 'AssigneesPopover';