"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.vulnerabilityDashboardLink = exports.findingsLinks = exports.cspDashboardLink = exports.benchmarksLink = void 0;
var _public = require("@kbn/cloud-security-posture-plugin/public");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _cloud_security_posture_dashboard_page = _interopRequireDefault(require("../common/images/cloud_security_posture_dashboard_page.png"));
var _cloud_native_vulnerability_management_dashboard_page = _interopRequireDefault(require("../common/images/cloud_native_vulnerability_management_dashboard_page.png"));
var _endpoints = require("../common/icons/endpoints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonLinkProperties = {
  hideTimeline: true,
  capabilities: [`${_constants.SERVER_APP_ID}.show`]
};
const findingsLinks = {
  ...(0, _public.getSecuritySolutionLink)('findings'),
  globalNavPosition: 4,
  ...commonLinkProperties
};
exports.findingsLinks = findingsLinks;
const cspDashboardLink = {
  ...(0, _public.getSecuritySolutionLink)('dashboard'),
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.cloudSecurityPostureDashboardDescription', {
    defaultMessage: 'An overview of findings across all CSP integrations.'
  }),
  landingImage: _cloud_security_posture_dashboard_page.default,
  ...commonLinkProperties
};
exports.cspDashboardLink = cspDashboardLink;
const vulnerabilityDashboardLink = {
  ...(0, _public.getSecuritySolutionLink)('vulnerability_dashboard'),
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.vulnerabilityDashboardDescription', {
    defaultMessage: 'Cloud Native Vulnerability Management (CNVM) allows you to identify vulnerabilities in your cloud workloads.'
  }),
  landingImage: _cloud_native_vulnerability_management_dashboard_page.default,
  ...commonLinkProperties
};
exports.vulnerabilityDashboardLink = vulnerabilityDashboardLink;
const benchmarksLink = {
  ...(0, _public.getSecuritySolutionLink)('benchmarks'),
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.cloudSecurityPostureBenchmarksDescription', {
    defaultMessage: 'View benchmark rules for Cloud Security Posture management.'
  }),
  landingIcon: _endpoints.IconEndpoints,
  ...commonLinkProperties
};
exports.benchmarksLink = benchmarksLink;