"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendToTimelineButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _use_selector = require("../../common/hooks/use_selector");
var _store = require("../../common/store");
var _actions = require("../../common/store/actions");
var _inputs = require("../../common/store/inputs");
var _constants = require("../../common/store/inputs/constants");
var _model = require("../../common/store/sourcerer/model");
var _timeline = require("../../../common/types/timeline");
var _timeline2 = require("../../../common/api/timeline");
var _translations = require("../../detections/components/alerts_table/translations");
var _use_create_timeline = require("../../timelines/components/timeline/properties/use_create_timeline");
var _actions2 = require("../../timelines/store/timeline/actions");
var _use_discover_in_timeline_context = require("../../common/components/discover_in_timeline/use_discover_in_timeline_context");
var _use_show_timeline = require("../../common/utils/timeline/use_show_timeline");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SendToTimelineButton = ({
  asEmptyButton,
  children,
  dataProviders,
  filters,
  timeRange,
  keepDataView,
  ...rest
}) => {
  var _dataProviders$3, _dataProviders$4;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    showAssistantOverlay
  } = (0, _elasticAssistant.useAssistantContext)();
  const [isTimelineBottomBarVisible] = (0, _use_show_timeline.useShowTimeline)();
  const {
    discoverStateContainer
  } = (0, _use_discover_in_timeline_context.useDiscoverInTimelineContext)();
  const isEsqlTabInTimelineDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('timelineEsqlTabDisabled');
  const getDataViewsSelector = (0, _react.useMemo)(() => _store.sourcererSelectors.getSourcererDataViewsSelector(), []);
  const {
    defaultDataView,
    signalIndexName
  } = (0, _use_selector.useDeepEqualSelector)(state => getDataViewsSelector(state));
  const hasTemplateProviders = dataProviders && dataProviders.find(provider => provider.type === 'template');
  const clearTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: hasTemplateProviders ? _timeline2.TimelineType.template : _timeline2.TimelineType.default
  });
  const configureAndOpenTimeline = (0, _react.useCallback)(() => {
    // Hide the assistant overlay so timeline can be seen (noop if using assistant in timeline)
    showAssistantOverlay({
      showOverlay: false
    });
    if (dataProviders || filters) {
      var _dataProviders$, _dataProviders$2;
      // If esql, don't reset filters or mess with dataview & time range
      if ((dataProviders === null || dataProviders === void 0 ? void 0 : (_dataProviders$ = dataProviders[0]) === null || _dataProviders$ === void 0 ? void 0 : _dataProviders$.queryType) === 'esql' || (dataProviders === null || dataProviders === void 0 ? void 0 : (_dataProviders$2 = dataProviders[0]) === null || _dataProviders$2 === void 0 ? void 0 : _dataProviders$2.queryType) === 'sql') {
        var _discoverStateContain;
        (_discoverStateContain = discoverStateContainer.current) === null || _discoverStateContain === void 0 ? void 0 : _discoverStateContain.appState.update({
          query: {
            esql: dataProviders[0].kqlQuery
          }
        });
        dispatch((0, _actions2.setActiveTabTimeline)({
          id: _timeline.TimelineId.active,
          activeTab: _timeline.TimelineTabs.esql
        }));
        dispatch((0, _actions2.showTimeline)({
          id: _timeline.TimelineId.active,
          show: true
        }));
        return;
      }

      // Reset the current timeline
      if (timeRange) {
        clearTimeline({
          timeRange
        });
      } else {
        clearTimeline();
      }
      if (dataProviders) {
        // Ensure Security Solution Default DataView is selected (so it's not just alerts)
        dispatch((0, _actions2.updateDataView)({
          id: _timeline.TimelineId.active,
          dataViewId: 'security-solution-default',
          indexNames: ['logs-*']
        }));

        // Added temporary queryType to dataproviders to support EQL/DSL
        switch (dataProviders[0].queryType) {
          case 'eql':
            // is EQL
            dispatch((0, _actions2.updateEqlOptions)({
              id: _timeline.TimelineId.active,
              field: 'query',
              value: dataProviders[0].kqlQuery
            }));
            dispatch((0, _actions2.setActiveTabTimeline)({
              id: _timeline.TimelineId.active,
              activeTab: _timeline.TimelineTabs.eql
            }));
            break;
          case 'kql':
            // is KQL
            dispatch((0, _actions2.applyKqlFilterQuery)({
              id: _timeline.TimelineId.active,
              filterQuery: {
                kuery: {
                  kind: 'kuery',
                  expression: dataProviders[0].kqlQuery
                },
                serializedQuery: dataProviders[0].kqlQuery
              }
            }));
            dispatch((0, _actions2.setActiveTabTimeline)({
              id: _timeline.TimelineId.active,
              activeTab: _timeline.TimelineTabs.query
            }));
            break;
          case 'dsl':
            const filter = {
              meta: {
                type: 'custom',
                disabled: false,
                negate: false,
                alias: dataProviders[0].name,
                key: 'query',
                value: dataProviders[0].kqlQuery
              },
              query: JSON.parse(dataProviders[0].kqlQuery)
            };
            dispatch((0, _actions2.setFilters)({
              id: _timeline.TimelineId.active,
              filters: [filter]
            }));
            dispatch((0, _actions2.setActiveTabTimeline)({
              id: _timeline.TimelineId.active,
              activeTab: _timeline.TimelineTabs.query
            }));
            break;
        }
      }

      // Use filters if more than a certain amount of ids for dom performance.
      if (filters) {
        dispatch((0, _actions2.setFilters)({
          id: _timeline.TimelineId.active,
          filters
        }));
      }
      // Only show detection alerts
      // (This is required so the timeline event count matches the prevalence count)
      if (!keepDataView) {
        dispatch(_actions.sourcererActions.setSelectedDataView({
          id: _model.SourcererScopeName.timeline,
          selectedDataViewId: defaultDataView.id,
          selectedPatterns: [signalIndexName || '']
        }));
      }
      // Unlock the time range from the global time range
      dispatch(_inputs.inputsActions.removeLinkTo([_constants.InputsModelId.timeline, _constants.InputsModelId.global]));
    }
  }, [showAssistantOverlay, dataProviders, filters, timeRange, keepDataView, dispatch, clearTimeline, discoverStateContainer, defaultDataView.id, signalIndexName]);

  // As we work around timeline visibility issues, we will disable the button if timeline isn't available
  const toolTipText = isTimelineBottomBarVisible ? _translations.ACTION_INVESTIGATE_IN_TIMELINE : _translations.ACTION_CANNOT_INVESTIGATE_IN_TIMELINE;
  const isDisabled = !isTimelineBottomBarVisible;
  if (((dataProviders === null || dataProviders === void 0 ? void 0 : (_dataProviders$3 = dataProviders[0]) === null || _dataProviders$3 === void 0 ? void 0 : _dataProviders$3.queryType) === 'esql' || (dataProviders === null || dataProviders === void 0 ? void 0 : (_dataProviders$4 = dataProviders[0]) === null || _dataProviders$4 === void 0 ? void 0 : _dataProviders$4.queryType) === 'sql') && isEsqlTabInTimelineDisabled) {
    return null;
  }
  return asEmptyButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": toolTipText,
    onClick: configureAndOpenTimeline,
    isDisabled: isDisabled,
    color: "text",
    flush: "both",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: toolTipText
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "aria-label": toolTipText,
    isDisabled: isDisabled,
    onClick: configureAndOpenTimeline
  }, rest), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: toolTipText
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
};
exports.SendToTimelineButton = SendToTimelineButton;
SendToTimelineButton.displayName = 'SendToTimelineButton';