"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomCodeBlock = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomCodeBlock = ({
  value
}) => {
  const theme = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "s",
    className: (0, _css.css)`
        background-color: ${theme.euiTheme.colors.lightestShade};
        .euiCodeBlock__pre {
          margin-bottom: 0;
          padding: ${theme.euiTheme.size.m};
          min-block-size: 48px;
        }
        .euiCodeBlock__controls {
          inset-block-start: ${theme.euiTheme.size.m};
          inset-inline-end: ${theme.euiTheme.size.m};
        }
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    fontSize: "m"
  }, value))));
};
exports.CustomCodeBlock = CustomCodeBlock;