"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observedUserDetailsSchema = void 0;
var _zod = require("zod");
var _request_basic_options = require("../model/request_basic_options");
var _inspect = require("../model/inspect");
var _timerange = require("../model/timerange");
var _factory_query_type = require("../model/factory_query_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const observedUserDetailsSchema = _request_basic_options.requestBasicOptionsSchema.extend({
  userName: _zod.z.string(),
  skip: _zod.z.boolean().optional(),
  timerange: _timerange.timerange,
  inspect: _inspect.inspect,
  factoryQueryType: _zod.z.literal(_factory_query_type.UsersQueries.observedDetails)
});
exports.observedUserDetailsSchema = observedUserDetailsSchema;