"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeSpecificRulesRequest = exports.UpgradeAllRulesRequest = exports.TPickVersionValues = exports.SkipRuleUpgradeReason = exports.RuleUpgradeSpecifier = exports.PickVersionValues = exports.PerformRuleUpgradeRequestBody = void 0;
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let PickVersionValues;
exports.PickVersionValues = PickVersionValues;
(function (PickVersionValues) {
  PickVersionValues["BASE"] = "BASE";
  PickVersionValues["CURRENT"] = "CURRENT";
  PickVersionValues["TARGET"] = "TARGET";
})(PickVersionValues || (exports.PickVersionValues = PickVersionValues = {}));
const TPickVersionValues = (0, _securitysolutionIoTsTypes.enumeration)('PickVersionValues', PickVersionValues);
exports.TPickVersionValues = TPickVersionValues;
const RuleUpgradeSpecifier = t.exact(t.intersection([t.type({
  rule_id: t.string,
  /**
   * This parameter is needed for handling race conditions with Optimistic Concurrency Control.
   * Two or more users can call upgrade/_review and upgrade/_perform endpoints concurrently.
   * Also, in general the time between these two calls can be anything.
   * The idea is to only allow the user to install a rule if the user has reviewed the exact version
   * of it that had been returned from the _review endpoint. If the version changed on the BE,
   * upgrade/_perform endpoint will return a version mismatch error for this rule.
   */
  revision: t.number,
  /**
   * The target version to upgrade to.
   */
  version: t.number
}), t.partial({
  pick_version: TPickVersionValues
})]));
exports.RuleUpgradeSpecifier = RuleUpgradeSpecifier;
const UpgradeSpecificRulesRequest = t.exact(t.intersection([t.type({
  mode: t.literal(`SPECIFIC_RULES`),
  rules: t.array(RuleUpgradeSpecifier)
}), t.partial({
  pick_version: TPickVersionValues
})]));
exports.UpgradeSpecificRulesRequest = UpgradeSpecificRulesRequest;
const UpgradeAllRulesRequest = t.exact(t.intersection([t.type({
  mode: t.literal(`ALL_RULES`)
}), t.partial({
  pick_version: TPickVersionValues
})]));
exports.UpgradeAllRulesRequest = UpgradeAllRulesRequest;
const PerformRuleUpgradeRequestBody = t.union([UpgradeAllRulesRequest, UpgradeSpecificRulesRequest]);
exports.PerformRuleUpgradeRequestBody = PerformRuleUpgradeRequestBody;
let SkipRuleUpgradeReason;
exports.SkipRuleUpgradeReason = SkipRuleUpgradeReason;
(function (SkipRuleUpgradeReason) {
  SkipRuleUpgradeReason["RULE_UP_TO_DATE"] = "RULE_UP_TO_DATE";
})(SkipRuleUpgradeReason || (exports.SkipRuleUpgradeReason = SkipRuleUpgradeReason = {}));