"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LandingLink = exports.LandingColumnLinks = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _links = require("../links");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Renders a link to either an external URL or an internal Kibana URL
const LandingLink = /*#__PURE__*/_react.default.memo(function LandingLink({
  item,
  urlState,
  onLinkClick,
  children,
  ...rest
}) {
  if (item.externalUrl != null) {
    // Link to outside Kibana
    const linkProps = {
      target: '_blank',
      external: true,
      href: item.externalUrl,
      ...(onLinkClick && !item.disabled && {
        onClick: () => onLinkClick(item.id)
      }),
      ...rest
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, linkProps, children);
  } else {
    // Kibana link
    const linkProps = {
      ...(0, _utils.getKibanaLinkProps)({
        item,
        urlState,
        onLinkClick
      }),
      ...rest
    };
    return /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, linkProps, children);
  }
});
exports.LandingLink = LandingLink;
const useSubLinkStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    container: (0, _react2.css)`
      margin-top: ${euiTheme.size.base};
    `
  };
};

// Renders a list of links in a column layout
const LandingColumnLinks = /*#__PURE__*/_react.default.memo(function LandingColumnLinks({
  items,
  urlState,
  onLinkClick
}) {
  const subLinkStyles = useSubLinkStyles();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    alignItems: "flexStart"
  }, items.map(subItem => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: subItem.id,
    grow: false,
    css: subLinkStyles.container,
    "data-test-subj": "LandingSubItem"
  }, /*#__PURE__*/_react.default.createElement(LandingLink, {
    item: subItem,
    urlState: urlState,
    onLinkClick: onLinkClick
  }, subItem.title))));
});
exports.LandingColumnLinks = LandingColumnLinks;