"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserProfileSettingsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A wrapper client around {@link UserSettingServiceStart} that exposes a method to get the current user's profile
 */
class UserProfileSettingsClient {
  constructor(logger) {
    (0, _defineProperty2.default)(this, "userSettingServiceStart", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = logger;
  }

  /**
   * Returns the current user's user profile settings
   *
   * @param request the KibanaRequest that is required to get the current user and their settings
   * @return the User Settings values retrieved from the UserSettingsServiceStart, if it has been set, otherwise,
   * default to an empty Record
   */
  async get(request) {
    let result = {};
    if (this.userSettingServiceStart) {
      result = await this.userSettingServiceStart.getCurrentUserProfileSettings(request);
    } else {
      this.logger.debug('UserSettingsServiceStart has not been set yet');
    }
    return result;
  }
  setUserSettingsServiceStart(userSettingServiceStart) {
    this.userSettingServiceStart = userSettingServiceStart;
  }
}
exports.UserProfileSettingsClient = UserProfileSettingsClient;