"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceAwarePrivilegeSection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _privilege_space_form = require("./privilege_space_form");
var _privilege_space_table = require("./privilege_space_table");
var _common = require("../../../../../../../common");
var _privilege_form_calculator = require("../privilege_form_calculator");
var _privilege_summary = require("../privilege_summary");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SpaceAwarePrivilegeSection extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "globalSpaceEntry", {
      id: '*',
      name: _i18n.i18n.translate('xpack.security.management.editRole.spaceAwarePrivilegeForm.globalSpacesName', {
        defaultMessage: '* All Spaces'
      }),
      color: '#D3DAE6',
      initials: '*',
      disabledFeatures: []
    });
    (0, _defineProperty2.default)(this, "renderKibanaPrivileges", () => {
      const {
        role
      } = this.props;
      const spacePrivileges = role.kibana;
      const hasAnyPrivileges = spacePrivileges.length > 0;
      if (hasAnyPrivileges) {
        const table = /*#__PURE__*/_react.default.createElement(_privilege_space_table.PrivilegeSpaceTable, {
          role: this.props.role,
          displaySpaces: this.getDisplaySpaces(),
          privilegeCalculator: new _privilege_form_calculator.PrivilegeFormCalculator(this.props.kibanaPrivileges, this.props.role),
          onChange: this.props.onChange,
          onEdit: this.onEditSpacesPrivileges,
          disabled: !this.props.editable
        });
        return /*#__PURE__*/_react.default.createElement("div", null, table, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), this.getAvailablePrivilegeButtons(true));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        iconType: "lock",
        title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.spacePrivilegeSection.noAccessToKibanaTitle",
          defaultMessage: "This role does not grant access to Kibana"
        })),
        titleSize: "xs",
        actions: this.getAvailablePrivilegeButtons(false)
      });
    });
    (0, _defineProperty2.default)(this, "getAvailablePrivilegeButtons", hasPrivilegesAssigned => {
      const hasAvailableSpaces = this.getAvailableSpaces().length > 0;

      // This shouldn't happen organically...
      if (!hasAvailableSpaces && !hasPrivilegesAssigned) {
        return null;
      }
      const addPrivilegeButton = !hasAvailableSpaces || !this.props.editable ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        onClick: this.addSpacePrivilege,
        iconType: 'plusInCircle',
        "data-test-subj": 'addSpacePrivilegeButton',
        isDisabled: !hasAvailableSpaces || !this.props.editable
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.spacePrivilegeSection.addSpacePrivilegeButton",
        defaultMessage: "Add Kibana privilege"
      }));
      if (!hasPrivilegesAssigned) {
        return addPrivilegeButton;
      }
      const viewMatrixButton = /*#__PURE__*/_react.default.createElement(_privilege_summary.PrivilegeSummary, {
        role: this.props.role,
        spaces: this.getDisplaySpaces(),
        kibanaPrivileges: this.props.kibanaPrivileges,
        canCustomizeSubFeaturePrivileges: this.props.canCustomizeSubFeaturePrivileges,
        spacesApiUi: this.props.spacesApiUi
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, addPrivilegeButton), hasPrivilegesAssigned && !(0, _common.isRoleReserved)(this.props.role) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, viewMatrixButton));
    });
    (0, _defineProperty2.default)(this, "getDisplaySpaces", () => {
      return [this.globalSpaceEntry, ...this.props.spaces];
    });
    (0, _defineProperty2.default)(this, "getAvailableSpaces", (includeSpacesFromPrivilegeIndex = -1) => {
      const spacesToExclude = _lodash.default.uniq(_lodash.default.flatten(this.props.role.kibana.map((entry, index) => {
        if (includeSpacesFromPrivilegeIndex === index) {
          return [];
        }
        return entry.spaces;
      })));
      return this.getDisplaySpaces().filter(displaySpace => !spacesToExclude.includes(displaySpace.id));
    });
    (0, _defineProperty2.default)(this, "addSpacePrivilege", () => {
      this.setState({
        showSpacePrivilegeEditor: true,
        privilegeIndex: -1
      });
    });
    (0, _defineProperty2.default)(this, "onSpacesPrivilegeChange", role => {
      this.setState({
        showSpacePrivilegeEditor: false,
        privilegeIndex: -1
      });
      this.props.onChange(role);
    });
    (0, _defineProperty2.default)(this, "onEditSpacesPrivileges", privilegeIndex => {
      this.setState({
        privilegeIndex,
        showSpacePrivilegeEditor: true
      });
    });
    (0, _defineProperty2.default)(this, "onCancelEditPrivileges", () => {
      this.setState({
        showSpacePrivilegeEditor: false
      });
    });
    this.state = {
      showSpacePrivilegeEditor: false,
      showPrivilegeMatrix: false,
      role: null,
      privilegeIndex: -1
    };
  }
  render() {
    var _uiCapabilities$space;
    const {
      uiCapabilities
    } = this.props;
    if (!((_uiCapabilities$space = uiCapabilities.spaces) !== null && _uiCapabilities$space !== void 0 && _uiCapabilities$space.manage)) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.spaceAwarePrivilegeForm.insufficientPrivilegesDescription",
          defaultMessage: "Insufficient Privileges"
        }),
        iconType: "warning",
        color: "danger",
        "data-test-subj": "userCannotManageSpacesCallout"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.spaceAwarePrivilegeForm.howToViewAllAvailableSpacesDescription",
        defaultMessage: "You are not authorized to view all available spaces."
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.spaceAwarePrivilegeForm.ensureAccountHasAllPrivilegesGrantedDescription",
        defaultMessage: "Please ensure your account has all privileges granted by the {kibanaAdmin} role, and try again.",
        values: {
          kibanaAdmin: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.editRole.spaceAwarePrivilegeForm.kibanaAdminTitle",
            defaultMessage: "kibana_admin"
          }))
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this.renderKibanaPrivileges(), this.state.showSpacePrivilegeEditor && /*#__PURE__*/_react.default.createElement(_privilege_space_form.PrivilegeSpaceForm, {
      role: this.props.role,
      kibanaPrivileges: this.props.kibanaPrivileges,
      onChange: this.onSpacesPrivilegeChange,
      onCancel: this.onCancelEditPrivileges,
      spaces: this.getAvailableSpaces(this.state.privilegeIndex),
      privilegeIndex: this.state.privilegeIndex,
      canCustomizeSubFeaturePrivileges: this.props.canCustomizeSubFeaturePrivileges
    })));
  }
}
exports.SpaceAwarePrivilegeSection = SpaceAwarePrivilegeSection;